/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.util.JSONUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConnectionTestResultEntity {
    private final List<EndpointResult> endpointResults;

    @JsonCreator
    public ConnectionTestResultEntity(@JsonProperty(value="endpointResults") @Nonnull List<EndpointResult> endpointResults) {
        this.endpointResults = new ArrayList<EndpointResult>(endpointResults);
    }

    @JsonCreator
    public ConnectionTestResultEntity() {
        this.endpointResults = Collections.emptyList();
    }

    @Nonnull
    public List<EndpointResult> getEndpointResults() {
        return this.endpointResults;
    }

    public boolean getAllSuccess() {
        return this.endpointResults.stream().allMatch(EndpointResult::isSuccess);
    }

    public static class EndpointResult {
        private final String description;
        private final String endpoint;
        private final boolean success;
        private final String returnCode;
        private final String responseBody;
        private final String infoBanner;
        private final String errorBanner;
        private final String warningBanner;

        @JsonCreator
        public EndpointResult(@JsonProperty(value="description") @Nullable String description, @JsonProperty(value="endpoint") @Nullable String endpoint, @JsonProperty(value="success") boolean success, @JsonProperty(value="returnCode") @Nullable String returnCode, @JsonProperty(value="responseBody") @Nullable String responseBody, @JsonProperty(value="infoBanner") @Nullable String infoBanner, @JsonProperty(value="errorBanner") @Nullable String errorBanner, @JsonProperty(value="warningBanner") @Nullable String warningBanner) {
            this.description = description;
            this.endpoint = endpoint;
            this.success = success;
            this.returnCode = returnCode;
            this.responseBody = responseBody;
            this.infoBanner = infoBanner;
            this.errorBanner = errorBanner;
            this.warningBanner = warningBanner;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public String getEndpoint() {
            return this.endpoint;
        }

        public boolean isSuccess() {
            return this.success;
        }

        @Nullable
        public String getReturnCode() {
            return this.returnCode;
        }

        @Nullable
        public String getResponseBody() {
            return JSONUtil.isValidJson((String)this.responseBody) ? JSONUtil.prettify((String)this.responseBody) : this.responseBody;
        }

        @Nullable
        public String getInfoBanner() {
            return this.infoBanner;
        }

        @Nullable
        public String getErrorBanner() {
            return this.errorBanner;
        }

        @Nullable
        public String getWarningBanner() {
            return this.warningBanner;
        }

        public static EndpointResult createError(@Nullable String description, @Nullable String endpoint, boolean success, @Nullable String returnCode, @Nullable String responseBody, @Nullable String errorBanner) {
            return new EndpointResult(description, endpoint, success, returnCode, responseBody, null, errorBanner, null);
        }

        public static EndpointResult createWarning(@Nullable String description, @Nullable String endpoint, boolean success, @Nullable String returnCode, @Nullable String responseBody, @Nullable String warningBanner) {
            return new EndpointResult(description, endpoint, success, returnCode, responseBody, null, null, warningBanner);
        }

        public static EndpointResult createInfo(@Nullable String description, @Nullable String endpoint, boolean success, @Nullable String returnCode, @Nullable String responseBody, @Nullable String infoBanner) {
            return new EndpointResult(description, endpoint, success, returnCode, responseBody, infoBanner, null, null);
        }

        public static EndpointResult create(@Nullable String description, @Nullable String endpoint, boolean success, @Nullable String returnCode, @Nullable String responseBody) {
            return new EndpointResult(description, endpoint, success, returnCode, responseBody, null, null, null);
        }
    }
}

