/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.SetUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.helpers.LozengeStyle;
import de.resolution.usersync.api.GenericUserSyncResult;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.rest.entities.SyncStatusDiffResultEntity;
import de.resolution.usersync.util.KeyValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Named(value="syncStatusDiffRestResource")
@Path(value="/usersync/syncStatusDiff")
public class SyncStatusDiffRestResource {
    private static final int MAX_NUMBER_ATTR_VALUES_IN_ROW = 10;
    private final PrivilegeChecker privilegeChecker;
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");

    @Inject
    public SyncStatusDiffRestResource(PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    public Response createSyncStatusDiffForSingleUserUpdate(String syncSingleUserResultString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        Optional messagesOptional;
        GenericUserSyncResult genericSingleUserResult;
        this.privilegeChecker.checkSysAdmin(request);
        if (syncSingleUserResultString == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"No input given\"}").build();
        }
        try {
            genericSingleUserResult = (GenericUserSyncResult)JSONUtil.fromJson((String)syncSingleUserResultString, SyncUserResult.class);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"Deserialse wrongD\"}").build();
        }
        if (genericSingleUserResult.getAtlasUserResult() == null) {
            SyncStatusDiffResultEntity entity = new SyncStatusDiffResultEntity(null, null, null, null, null, AtlasUserResult.ErrorType.NONE);
            return Response.ok().entity((Object)JSONUtil.asJson((Object)entity)).cacheControl(ccNoCache).build();
        }
        AtlasUser resultingUser = genericSingleUserResult.getAtlasUserResult().getResultingUser().orElse(null);
        AtlasUser initialUser = genericSingleUserResult.getAtlasUserResult().getInitialUser().orElse(null);
        AtlasUser inputUser = genericSingleUserResult.getAtlasUserResult().getInputUser().orElse(null);
        String messages = null;
        List<KeyValue> resultingUserResultForUi = null;
        List<KeyValue> initialUserForUi = null;
        List<KeyValue> inputUserForUi = null;
        List diffResult = null;
        if (resultingUser != null) {
            resultingUserResultForUi = SyncStatusDiffRestResource.createUserResultForUi(resultingUser);
        }
        if (initialUser != null) {
            initialUserForUi = SyncStatusDiffRestResource.createUserResultForUi(initialUser);
        }
        if (inputUser != null) {
            inputUserForUi = SyncStatusDiffRestResource.createUserResultForUi(inputUser);
        }
        if ((messagesOptional = genericSingleUserResult.getAtlasUserResult().getMessages()).isPresent()) {
            messages = String.join((CharSequence)", ", (Iterable)messagesOptional.get());
        }
        AtlasUserResult.ErrorType errorType = genericSingleUserResult.getAtlasUserResult().getErrorType();
        Optional diffJsonOptional = genericSingleUserResult.getAtlasUserResult().getDiff();
        if (!diffJsonOptional.isPresent()) {
            return Response.ok().entity((Object)JSONUtil.asJson((Object)new SyncStatusDiffResultEntity(Collections.emptyList(), resultingUserResultForUi, initialUserForUi, inputUserForUi, messages, errorType))).cacheControl(ccNoCache).build();
        }
        if (initialUser != null && resultingUser != null) {
            JsonNode diffJson = (JsonNode)diffJsonOptional.get();
            diffResult = StreamSupport.stream(diffJson.spliterator(), false).map(node -> this.createDiffEntry(resultingUser, initialUser, (JsonNode)node)).filter(Objects::nonNull).distinct().sorted((e1, e2) -> SyncStatusDiffRestResource.sortAttributesByKeyWithCustomOrder(e1.getKey(), e2.getKey())).collect(Collectors.toList());
        }
        return Response.ok().entity((Object)JSONUtil.asJson((Object)new SyncStatusDiffResultEntity(diffResult, resultingUserResultForUi, initialUserForUi, inputUserForUi, messages, errorType))).cacheControl(ccNoCache).build();
    }

    @Nonnull
    private static List<KeyValue> createUserResultForUi(AtlasUser atlasUser) {
        return atlasUser.getAttributeKeys().stream().filter(key -> !key.equals("ATLAS_USER_TIMESTAMP")).map(key -> new KeyValue(AtlasUserKeys.getNameForUi((String)key), CollectionUtil.formatAsString((Collection)atlasUser.getAttributeValues(key)))).sorted((e1, e2) -> SyncStatusDiffRestResource.sortAttributesByKeyWithCustomOrder(e1.getKey(), e2.getKey())).collect(Collectors.toList());
    }

    @Nullable
    private SyncStatusDiffResultEntity.DiffEntry createDiffEntry(@Nonnull AtlasUser resultingUser, @Nonnull AtlasUser initialUser, @Nonnull JsonNode node) {
        if (!node.has("op") || !node.has("path")) {
            return null;
        }
        String op = node.get("op").asText();
        String path = node.get("path").asText();
        if (path.startsWith("/reference")) {
            return null;
        }
        String[] attrArr = path.split("/");
        if (attrArr.length < 3) {
            return null;
        }
        String attr = attrArr[2];
        if (attr.equals("ATLAS_USER_TIMESTAMP")) {
            return null;
        }
        List<String> oldValues = initialUser.getAttributeValues(attr).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        List<String> newValues = resultingUser.getAttributeValues(attr).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        oldValues = SyncStatusDiffRestResource.truncateListWithSummary(oldValues);
        newValues = SyncStatusDiffRestResource.truncateListWithSummary(newValues);
        String oldValue = CollectionUtil.formatAsString(oldValues);
        String newValue = CollectionUtil.formatAsString(newValues);
        Set initialSet = initialUser.getAttributeValues(attr);
        Set resultingSet = resultingUser.getAttributeValues(attr);
        String addedValues = SetUtil.difference((Set)resultingSet, (Set)initialSet).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
        String removedValues = SetUtil.difference((Set)initialSet, (Set)resultingSet).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
        String unchangedValues = SetUtil.intersect((Set)initialSet, (Set)resultingSet).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
        if (initialSet.size() > 1 || resultingSet.size() > 1) {
            if (!addedValues.isEmpty() && !removedValues.isEmpty()) {
                op = "ADDED and REMOVED";
            } else if (!addedValues.isEmpty()) {
                op = "ADD";
            } else if (!removedValues.isEmpty()) {
                op = "REMOVED";
            }
        }
        String style = LozengeStyle.GREY.getStyle();
        if (op.equalsIgnoreCase("REPLACE")) {
            style = LozengeStyle.ORANGE.getStyle();
        } else if (op.equalsIgnoreCase("ADD")) {
            style = LozengeStyle.GREEN.getStyle();
        } else if (op.equalsIgnoreCase("REMOVED")) {
            style = LozengeStyle.RED.getStyle();
        } else if (op.equalsIgnoreCase("ADDED and REMOVED")) {
            style = LozengeStyle.PURPLE.getStyle();
        }
        return new SyncStatusDiffResultEntity.DiffEntry(AtlasUserKeys.getNameForUi((String)attr), oldValue, newValue, op, style, initialSet.size() > 1 || resultingSet.size() > 1, String.join((CharSequence)"\n", addedValues), String.join((CharSequence)"\n", removedValues), String.join((CharSequence)"\n", unchangedValues), SyncStatusDiffRestResource.createDownloadResult(addedValues, removedValues, unchangedValues));
    }

    @Nonnull
    private static List<String> truncateListWithSummary(@Nonnull List<String> values) {
        if (values.size() > 10) {
            int oldSize = values.size();
            values = values.subList(0, 10);
            values.add(" ... and " + (oldSize - 10) + " more");
        }
        return values;
    }

    @Nonnull
    private static String createDownloadResult(@Nonnull String addedValues, @Nonnull String removedValues, @Nonnull String unchangedValues) {
        return "Added\n=====\n\n" + addedValues + "\n\n\nRemoved\n=======\n\n" + removedValues + "\n\n\nUnchanged\n========\n\n" + unchangedValues + "\n";
    }

    private static int sortAttributesByKeyWithCustomOrder(@Nonnull String key1, @Nonnull String key2) {
        List<String> order = Arrays.asList("Username", "Firstname", "Lastname", "Fullname", "Email", "Groups");
        int index1 = order.indexOf(key1);
        int index2 = order.indexOf(key2);
        if (index1 != -1 && index2 != -1) {
            return Integer.compare(index1, index2);
        }
        if (index1 != -1) {
            return -1;
        }
        if (index2 != -1) {
            return 1;
        }
        return key1.compareTo(key2);
    }
}

