/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorSupportInformation;
import de.resolution.usersync.api.SupportInformationGenerator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component(value="userSyncSupportRestResource")
@Path(value="/usersync/support")
public class SupportRestResource {
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final SupportInformationGenerator supportInformationGenerator;

    @Inject
    public SupportRestResource(PrivilegeChecker privilegeChecker, SupportInformationGenerator supportInformationGenerator) {
        this.privilegeChecker = privilegeChecker;
        this.supportInformationGenerator = supportInformationGenerator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response generateSupportInformation(@DefaultValue(value="true") @QueryParam(value="sanitize") boolean sanitize, @DefaultValue(value="all") @QueryParam(value="id") String id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        if (id.equals("all")) {
            return Response.ok((Object)JSONUtil.asJson(this.supportInformationGenerator.generate(sanitize))).cacheControl(ccNoCache).build();
        }
        ConnectorSupportInformation connectorSupportInformation = this.supportInformationGenerator.generate(id, sanitize);
        if (connectorSupportInformation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)JSONUtil.asJson((Object)this.supportInformationGenerator.generate(id, sanitize))).cacheControl(ccNoCache).build();
    }
}

