/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.api.RestfulTableResultEntity;
import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.NotificationService;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/usersync/notifications")
public class NotificationRestResource {
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final NotificationService notificationService;

    @Inject
    public NotificationRestResource(PrivilegeChecker privilegeChecker, NotificationService notificationService) {
        this.privilegeChecker = privilegeChecker;
        this.notificationService = notificationService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response getAllNotifications(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return new RestfulTableResultEntity<Notification>(this.notificationService.getAll()).toResponse();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{contextId}")
    public Response getNotificationsPerConnector(@PathParam(value="contextId") String contextId, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return new RestfulTableResultEntity<Notification>(this.notificationService.getAll(contextId)).toResponse();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{contextId}/{messageId}")
    public Response getNotification(@PathParam(value="contextId") String contextId, @PathParam(value="messageId") String messageId, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        Notification notification = this.notificationService.get(contextId, messageId);
        if (notification == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)JSONUtil.asJson((Object)notification)).cacheControl(ccNoCache).build();
    }

    @DELETE
    @Path(value="/{contextId}/{messageId}")
    public Response deleteNotification(@PathParam(value="contextId") String contextId, @PathParam(value="messageId") String messageId, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        this.notificationService.ack(contextId, messageId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

