/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.commons.validate.api.ValidationResultWithId;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorServiceWithJsonNodeMethods;
import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="importExportRestResource")
@Path(value="/usersync/importexport")
public class ImportExportRestResource {
    private static final Logger logger = LoggerFactory.getLogger(ImportExportRestResource.class);
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorServiceWithJsonNodeMethods connectorService;
    private final NotificationService notificationService;

    @Inject
    public ImportExportRestResource(@Nonnull PrivilegeChecker privilegeChecker, @Nonnull ConnectorServiceWithJsonNodeMethods connectorService, @Nonnull NotificationService notificationService) {
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
        this.notificationService = notificationService;
    }

    @GET
    @Produces(value={"application/json"})
    @Nonnull
    public Response exportAll(@Nonnull @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        List configs = this.connectorService.getConnectors().stream().map(cvr -> cvr.getConnector().getConfiguration()).collect(Collectors.toList());
        String configsAsJson = JSONUtil.asJson(configs);
        String filename = String.format("connectors-%d.json", System.currentTimeMillis());
        return Response.ok((Object)configsAsJson).header("Content-Disposition", (Object)("attachment; filename=" + filename)).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Nonnull
    public Response exportSingle(@Nonnull @PathParam(value="id") String id, @Nonnull @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConfigurationFailedException, ConnectorFactoryNotAvailableException {
        this.privilegeChecker.checkSysAdmin(request);
        try {
            ConnectorAndValidationResult conn = this.connectorService.getConnectorByUniqueId(id);
            String configAsJson = JSONUtil.asJson(conn.getConnector().getConfiguration());
            String filename = String.format("connector-%s-%d.json", StringUtil.sanitize((String)id), System.currentTimeMillis());
            return Response.ok((Object)configAsJson).header("Content-Disposition", (Object)("attachment; filename=" + filename)).cacheControl(ccNoCache).build();
        }
        catch (ConnectorNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
        }
    }

    boolean jsonLooksOk(@Nonnull JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode current : arrayNode) {
                if (this.connectorJsonLooksOk(current)) continue;
                return false;
            }
            return true;
        }
        return this.connectorJsonLooksOk(jsonNode);
    }

    boolean connectorJsonLooksOk(@Nonnull JsonNode jsonNode) {
        return jsonNode.hasNonNull("uniqueId") && jsonNode.hasNonNull("connectorClass") && jsonNode.hasNonNull("name");
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Nonnull
    public Response importConnectors(@Nonnull String jsonString, @Nonnull @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        JsonNode jsonNode = JSONUtil.asJsonNode((String)jsonString);
        if (!this.jsonLooksOk(jsonNode)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"JSON does not look like a connector or a list of connectors\"}").build();
        }
        ArrayList<ValidationResultWithId> validationResults = new ArrayList<ValidationResultWithId>();
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode currentNode : arrayNode) {
                ValidationResultWithId currentValidationResult = this.importSingleConnector(currentNode);
                validationResults.add(currentValidationResult);
            }
            return Response.ok().entity((Object)ImportExportRestResource.createResponseEntityString(validationResults)).cacheControl(ccNoCache).build();
        }
        ValidationResultWithId result = this.importSingleConnector(jsonNode);
        return Response.ok().entity((Object)ImportExportRestResource.createResponseEntityString(Collections.singletonList(result))).cacheControl(ccNoCache).build();
    }

    @Nonnull
    public static String createResponseEntityString(@Nonnull List<ValidationResultWithId> validationResultWithIds) {
        return JSONUtil.asJsonWithoutNullOrEmpty(validationResultWithIds);
    }

    @Nonnull
    public ValidationResultWithId importSingleConnector(@Nonnull JsonNode configurationNode) {
        boolean addedNotification = false;
        String uniqueId = JSONUtil.readString((JsonNode)configurationNode, (String)"uniqueId");
        if (StringUtil.isNullOrEmpty((String)uniqueId)) {
            ValidationResult result = ValidationResult.create();
            result.add("uniqueId", "uniqueId must be set");
            this.notificationService.add(Notification.createForConnector("Unique ID must be set", Notification.Level.ERROR, "UNKNOWN_UID"));
            return ValidationResultWithId.create((ValidationResult)result, (String)"unknown");
        }
        String connectorClass = JSONUtil.readString((JsonNode)configurationNode, (String)"connectorClass");
        if (connectorClass == null) {
            ValidationResult result = ValidationResult.create();
            result.add("connectorClass", "connectorClass must be set");
            this.notificationService.add(Notification.createForConnector(uniqueId + ": connectorClass must be set", Notification.Level.ERROR, uniqueId));
            return ValidationResultWithId.create((ValidationResult)result, (String)uniqueId);
        }
        logger.debug("Connector class is {}", (Object)connectorClass);
        if (this.connectorService.connectorExists(uniqueId)) {
            logger.debug("Connector {} exists already, applying configuration", (Object)uniqueId);
            try {
                Object existingConfig = this.connectorService.getConnectorByUniqueId(uniqueId).getConnector().getConfiguration();
                long existingDirectory = existingConfig.getDirectoryId();
                long newDirectory = JSONUtil.readLong((JsonNode)configurationNode, (String)"directoryId");
                String directoryMessage = null;
                if (newDirectory != existingDirectory) {
                    JSONUtil.updateValue((JsonNode)configurationNode, (String)"directoryId", (long)existingDirectory);
                    directoryMessage = "Kept existing directory id " + existingDirectory + " instead of updating it to " + newDirectory;
                }
                ConnectorAndValidationResult cvr = this.connectorService.configure(uniqueId, configurationNode);
                ValidationResultWithId validationResult = ValidationResultWithId.create((ValidationResultWithId)cvr.getValidationResult());
                validationResult.removeEmptyChildren();
                if (directoryMessage != null) {
                    validationResult.add("directoryId", null, directoryMessage);
                    this.notificationService.add(Notification.createForConnector(cvr.getConnector().getName() + ": " + directoryMessage, Notification.Level.WARNING, uniqueId));
                    addedNotification = true;
                }
                if (!validationResult.isValid()) {
                    String msgId = Notification.generateMessageId();
                    this.notificationService.add(Notification.createForConnector(cvr.getConnector().getName() + ": Connector configuration is not valid and has not been applied. Search logs for " + msgId + " for details.", Notification.Level.ERROR, msgId, uniqueId));
                    if (logger.isErrorEnabled()) {
                        logger.warn(" {}: Imported configuration is invalid and was not applied to existing connector: {}", (Object)msgId, (Object)JSONUtil.asJson((Object)validationResult));
                    }
                    addedNotification = true;
                }
                if (!addedNotification) {
                    this.notificationService.add(Notification.createForConnector(cvr.getConnector().getName() + " has been updated.", Notification.Level.INFO, uniqueId));
                }
                return validationResult;
            }
            catch (Exception e) {
                ValidationResult result = ValidationResult.create();
                result.addError(e.getClass().getName() + ": " + e.getMessage());
                this.notificationService.add(Notification.createForConnector(e.getClass().getName() + ": " + e.getMessage(), Notification.Level.ERROR, uniqueId));
                return ValidationResultWithId.create((ValidationResult)result, (String)uniqueId);
            }
        }
        logger.debug("Connector {} seems to be an new connector", (Object)uniqueId);
        return this.importNewConnector(configurationNode, addedNotification);
    }

    @Nonnull
    private ValidationResultWithId importNewConnector(@Nonnull JsonNode configurationNode, boolean addedNotification) {
        String uniqueId = JSONUtil.readString((JsonNode)configurationNode, (String)"uniqueId");
        if (StringUtil.isNullOrEmpty((String)uniqueId)) {
            uniqueId = "unknown";
        }
        long directoryIdInJson = JSONUtil.readLong((JsonNode)configurationNode, (String)"directoryId");
        try {
            Object connector = this.connectorService.createWithConfiguration(configurationNode);
            ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.configure(connector.getUniqueId(), configurationNode);
            long createdDirectoryId = connectorAndValidationResult.getConnector().getConfiguration().getDirectoryId();
            ValidationResultWithId validationResult = ValidationResultWithId.create((ValidationResultWithId)connectorAndValidationResult.getValidationResult());
            if (directoryIdInJson != createdDirectoryId) {
                String message = "Using newly created directory " + createdDirectoryId + " instead of " + directoryIdInJson;
                validationResult.add("directoryId", null, message);
                this.notificationService.add(Notification.createForConnector(connector.getName() + ": " + message, Notification.Level.WARNING, uniqueId));
                addedNotification = true;
            }
            validationResult.removeEmptyChildren();
            if (!validationResult.isValid()) {
                this.notificationService.add(Notification.createForConnector(connector.getName() + ": Connector configuration is not valid, edit the configuration to fix.", Notification.Level.ERROR, uniqueId));
                addedNotification = true;
            }
            if (!addedNotification) {
                this.notificationService.add(Notification.createForConnector(connector.getName() + " has been created.", Notification.Level.INFO, uniqueId));
            }
            return validationResult;
        }
        catch (Exception e) {
            logger.warn("Importing new connector failed", (Throwable)e);
            ValidationResult validationResult = ValidationResult.create();
            validationResult.addError(e.getMessage());
            this.notificationService.add(Notification.createForConnector("Failed to create Connector " + uniqueId + ": " + e.getMessage(), Notification.Level.ERROR, uniqueId));
            return ValidationResultWithId.create((ValidationResult)validationResult, (String)uniqueId);
        }
    }
}

