/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.AtlasUserDirectoryBuilder;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.rest.entities.CreateDirectoryResult;
import de.resolution.usersync.rest.entities.DirectorySelection;
import de.resolution.usersync.rest.entities.ExtendedDirectoryEntity;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.stream.Collectors;

@Named(value="directoryRestResource")
@Path(value="/directory")
public class DirectoryRestResource {
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final DirectoryAdapter directoryAdapter;
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;

    @Inject
    public DirectoryRestResource(DirectoryAdapter directoryAdapter, PrivilegeChecker privilegeChecker, ConnectorService connectorService) {
        this.directoryAdapter = directoryAdapter;
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDirectories(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson((Object)this.directoryAdapter.getDirectories())).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/atlasuser")
    public Response getAtlasUserDirectories(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson((Object)this.directoryAdapter.getAtlasUserDirectories())).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/writable")
    public Response getWritableAtlasUserDirectories(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson(this.directoryAdapter.getWritableDirectories().stream().map(ExtendedDirectoryEntity::new).collect(Collectors.toList()))).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getDirectory(@PathParam(value="id") long id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        AtlasUserDirectory directoryEntity = this.directoryAdapter.get(id);
        if (directoryEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
        }
        return Response.ok().entity((Object)JSONUtil.asJson((Object)new ExtendedDirectoryEntity(directoryEntity))).cacheControl(ccNoCache).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(AtlasUserDirectory directoryEntity, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, DirectoryNameExistsAlreadyException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson((Object)this.directoryAdapter.create(directoryEntity))).cacheControl(ccNoCache).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") long id, AtlasUserDirectory directoryEntity, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, DirectoryNotFoundException, InvalidOperationException, DirectoryNameExistsAlreadyException {
        this.privilegeChecker.checkSysAdmin(request);
        AtlasUserDirectory existing = this.directoryAdapter.get(id);
        if (existing == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
        }
        if (Objects.equals(existing.getName(), directoryEntity.getName()) && Objects.equals(existing.getDescription(), directoryEntity.getDescription())) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).cacheControl(ccNoCache).build();
        }
        AtlasUserDirectory toUpdate = AtlasUserDirectory.builder((AtlasUserDirectory)directoryEntity).id(existing.getId()).build();
        return Response.ok().entity((Object)JSONUtil.asJson((Object)this.directoryAdapter.update(toUpdate))).cacheControl(ccNoCache).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") long id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, DirectoryNotFoundException, InvalidOperationException, AtlasUserOperationFailedException {
        this.privilegeChecker.checkSysAdmin(request);
        this.directoryAdapter.delete(id);
        return Response.noContent().cacheControl(ccNoCache).build();
    }

    @POST
    @Path(value="/createNewDirectoryBasedOnOther/{id}")
    @Produces(value={"application/json"})
    public Response createNewDirectoryBasedOnOther(@PathParam(value="id") long id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, DirectoryNameExistsAlreadyException, InvalidOperationException {
        this.privilegeChecker.checkSysAdmin(request);
        AtlasUserDirectory res = this.directoryAdapter.get(id);
        String directoryName = "new Directory";
        String directoryDescription = "";
        if (res != null) {
            directoryName = res.getName();
            directoryDescription = res.getDescription();
        }
        String newName = this.connectorService.makeDirectoryNameUnique(directoryName);
        String newDescription = directoryDescription;
        AtlasUserDirectory createdDirectory = this.directoryAdapter.create(AtlasUserDirectory.builder().name(newName).description(newDescription).build());
        CreateDirectoryResult createDirectoryResult = new CreateDirectoryResult(createdDirectory.getId(), new DirectorySelection(this.connectorService.getAllDirectories(), false));
        return Response.ok().entity((Object)JSONUtil.asJson((Object)createDirectoryResult)).cacheControl(ccNoCache).build();
    }

    @POST
    @Path(value="/rename/{id}")
    public Response renameDirectory(@PathParam(value="id") long id, @Nonnull String body, @Context @Nonnull HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        AtlasUserDirectory existingDirectory = this.directoryAdapter.get(id);
        if (existingDirectory == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RenameDirectoryEntity renameData = (RenameDirectoryEntity)JSONUtil.fromJson((String)body, RenameDirectoryEntity.class);
        String newName = renameData.getNewName();
        if (newName == null || newName.trim().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JSONUtil.asJson((Object)"New name must be set")).build();
        }
        String existingName = existingDirectory.getName();
        String existingDescription = existingDirectory.getDescription();
        String newDescription = renameData.getNewDescription();
        if (newName.equals(existingName) && (newDescription == null || newDescription.equals(existingDescription))) {
            return Response.ok().entity((Object)JSONUtil.asJson((Object)new DirectorySelection(this.connectorService.getAllDirectories(), false))).cacheControl(ccNoCache).build();
        }
        AtlasUserDirectoryBuilder directoryBuilder = AtlasUserDirectory.builder().id(existingDirectory.getId()).name(newName);
        if (newDescription == null || newDescription.trim().isEmpty()) {
            directoryBuilder.description(existingDescription);
        } else {
            directoryBuilder.description(newDescription);
        }
        AtlasUserDirectory directoryToUpdate = directoryBuilder.build();
        try {
            this.directoryAdapter.update(directoryToUpdate);
            return Response.ok().entity((Object)JSONUtil.asJson((Object)new DirectorySelection(this.connectorService.getAllDirectories(), false))).cacheControl(ccNoCache).build();
        }
        catch (DirectoryNotFoundException | InvalidOperationException e) {
            return Response.serverError().entity((Object)JSONUtil.asJson((Object)e.getMessage())).build();
        }
        catch (DirectoryNameExistsAlreadyException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JSONUtil.asJson((Object)"Directory name is already in use")).build();
        }
    }

    public static class RenameDirectoryEntity {
        @Nullable
        private final String newName;
        @Nullable
        private final String newDescription;

        @JsonCreator
        public RenameDirectoryEntity(@Nullable @JsonProperty(value="newName") String newName, @Nullable @JsonProperty(value="newDescription") String newDescription) {
            this.newName = newName;
            this.newDescription = newDescription;
        }

        @Nullable
        public String getNewName() {
            return this.newName;
        }

        @Nullable
        public String getNewDescription() {
            return this.newDescription;
        }
    }
}

