/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.rest.RestUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;

@Named(value="directoryAssignmentRestResource")
@Path(value="/usersync/directoryassignment")
public class DirectoryAssignmentRestResource {
    private final DirectoryAdapter directoryAdapter;
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;

    @Inject
    public DirectoryAssignmentRestResource(@Nonnull DirectoryAdapter directoryAdapter, @Nonnull PrivilegeChecker privilegeChecker, @Nonnull ConnectorService connectorService) {
        this.directoryAdapter = directoryAdapter;
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDirectoryAssignments(@QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        ArrayList<DirectoryAssignmentEntity> directoryAssignmentEntities = new ArrayList<DirectoryAssignmentEntity>();
        HashSet<Long> usedDirectories = new HashSet<Long>();
        for (ConnectorAndValidationResult connectorAndValidationResult : this.connectorService.getConnectors()) {
            Object connector = connectorAndValidationResult.getConnector();
            long directoryId = connector.getConfiguration().getDirectoryId();
            usedDirectories.add(directoryId);
            AtlasUserDirectory directory = this.directoryAdapter.get(directoryId);
            if (directory == null) continue;
            directoryAssignmentEntities.add(new DirectoryAssignmentEntity(connector.getConfiguration().getUniqueId(), connector.getName(), directory.getName(), directory.getId(), directory.isAtlasUser()));
        }
        for (AtlasUserDirectory directory : this.directoryAdapter.getDirectories()) {
            if (usedDirectories.contains(directory.getId()) || !directory.isAtlasUser()) continue;
            directoryAssignmentEntities.add(new DirectoryAssignmentEntity(null, null, directory.getName(), directory.getId(), directory.isAtlasUser()));
        }
        directoryAssignmentEntities.sort(Comparator.comparing(DirectoryAssignmentEntity::getDirectoryName));
        return RestUtil.cutToPage(directoryAssignmentEntities, page, limit);
    }

    private static class DirectoryAssignmentEntity {
        private final String connectorUniqueId;
        private final String connectorName;
        private final String directoryName;
        private final long directoryId;
        private final boolean atlasUser;

        public DirectoryAssignmentEntity(@Nullable String connectorUniqueId, @Nullable String connectorName, @Nonnull String directoryName, long directoryId, boolean atlasUser) {
            this.connectorUniqueId = connectorUniqueId;
            this.connectorName = connectorName;
            this.directoryName = directoryName;
            this.directoryId = directoryId;
            this.atlasUser = atlasUser;
        }

        public String getConnectorUniqueId() {
            return this.connectorUniqueId;
        }

        public String getConnectorName() {
            return this.connectorName;
        }

        public String getDirectoryName() {
            return this.directoryName;
        }

        public long getDirectoryId() {
            return this.directoryId;
        }

        public boolean isAtlasUser() {
            return this.atlasUser;
        }
    }
}

