/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="connectionTestRestResource")
@Path(value="/usersync/connectionTest")
public class ConnectionTestRestResource {
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;
    private final Logger logger = LoggerFactory.getLogger(ConnectionTestRestResource.class);

    @Inject
    public ConnectionTestRestResource(PrivilegeChecker privilegeChecker, ConnectorService connectorService) {
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
    }

    @Produces(value={"application/json"})
    @GET
    public Response doConnectionTest(@QueryParam(value="connectorUID") String connectorUID, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        ConnectorAndValidationResult connector;
        this.privilegeChecker.checkSysAdmin(request);
        if (connectorUID == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"You must provide the connector UID\"}").build();
        }
        try {
            connector = this.connectorService.getConnectorByUniqueId(connectorUID);
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotFoundException e) {
            this.logger.error("Could not find connector because ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)" {\"message\": \"Could not load the connector, please check the logs\"}").build();
        }
        if (!connector.getValidationResult().isValid()) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)" {\"message\": \"Cannot do connection test because connector is not valid\"}").build();
        }
        ConnectionTestResultEntity result = new ConnectionTestResultEntity(connector.getConnector().doConnectionTest());
        return Response.ok().entity((Object)JSONUtil.asJson((Object)result)).cacheControl(ccNoCache).build();
    }
}

