/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.requiredgroups;

import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.impl.requiredgroups.LocalRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckFailedException;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexBasedRequiredGroupChecker
implements LocalRequiredGroupChecker {
    private static final Logger logger = LoggerFactory.getLogger(RegexBasedRequiredGroupChecker.class);
    private final List<String> requiredConnectorGroups;

    public RegexBasedRequiredGroupChecker(@Nonnull List<String> requiredConnectorGroups) {
        requiredConnectorGroups.forEach(requiredConnectorGroup -> {
            try {
                Pattern.compile(requiredConnectorGroup);
            }
            catch (PatternSyntaxException exception) {
                throw new RuntimeException("Invalid regex pattern for required group", exception);
            }
        });
        this.requiredConnectorGroups = requiredConnectorGroups;
    }

    @Override
    public boolean isRequiredGroup(ConnectorGroup connectorGroup) throws RequiredGroupCheckFailedException {
        if (this.requiredConnectorGroups.isEmpty()) {
            return true;
        }
        if (connectorGroup.getName() == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Required group has no attribute name: {}", (Object)JSONUtil.asJson((Object)connectorGroup.getGroupData()));
            }
            return false;
        }
        return CollectionUtil.matchesAny((String)connectorGroup.getName(), this.requiredConnectorGroups);
    }
}

