/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.requiredgroups;

import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.impl.requiredgroups.LocalRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerGroovyCode;
import groovy.lang.GroovyClassLoader;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyBasedRequiredGroupChecker
implements LocalRequiredGroupChecker {
    private final RequiredGroupCheckerGroovyCode groovyCheckerCode;

    private GroovyBasedRequiredGroupChecker(RequiredGroupCheckerGroovyCode groovyCheckerCode) {
        this.groovyCheckerCode = groovyCheckerCode;
    }

    public static GroovyBasedRequiredGroupChecker create(@Nonnull String groovyCode) throws GroovyCompilationFailedException {
        RequiredGroupCheckerGroovyCode connectorCode = GroovyBasedRequiredGroupChecker.compileGroovyCode(groovyCode);
        return new GroovyBasedRequiredGroupChecker(connectorCode);
    }

    public static RequiredGroupCheckerGroovyCode compileGroovyCode(String groovyCode) throws GroovyCompilationFailedException {
        RequiredGroupCheckerGroovyCode requiredGroupCheckerGroovyCode;
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStarImports(new String[]{"de.resolution.commons.data", "javax.annotation"});
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        compilerConfig.setScriptBaseClass("de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerGroovyCode");
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(RequiredGroupCheckerGroovyCode.class.getClassLoader(), compilerConfig);
        try {
            Class scriptClass = groovyClassLoader.parseClass(groovyCode);
            requiredGroupCheckerGroovyCode = (RequiredGroupCheckerGroovyCode)((Object)scriptClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable throwable) {
            try {
                try {
                    groovyClassLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CompilationFailedException e) {
                throw new GroovyCompilationFailedException((Exception)e);
            }
        }
        groovyClassLoader.close();
        return requiredGroupCheckerGroovyCode;
    }

    @Override
    public boolean isRequiredGroup(ConnectorGroup connectorGroup) throws RequiredGroupCheckFailedException {
        try {
            return this.groovyCheckerCode.isRequiredGroup(connectorGroup.getGroupDataAsStructuredData());
        }
        catch (Exception e) {
            throw new RequiredGroupCheckFailedException(e);
        }
    }

    public static class GroovyCompilationFailedException
    extends RequiredGroupCheckFailedException {
        public GroovyCompilationFailedException(Exception cause) {
            super(cause);
        }
    }
}

