/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.oauth;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.impl.oauth.AbstractOAuthServlet;
import de.resolution.usersync.spi.oauth.OAuthAuthorizationCodeFlow;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@UnrestrictedAccess
@Component
public class OauthServlet
extends AbstractOAuthServlet {
    private static final Logger logger = LoggerFactory.getLogger(OauthServlet.class);
    private final ConnectorService connectorService;

    @Inject
    public OauthServlet(ConnectorService connectorService, @ComponentImport TemplateRenderer templateRenderer) {
        super(templateRenderer, "/oauthAuthorization.vm");
        this.connectorService = connectorService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        String code = req.getParameter("code");
        String state = req.getParameter("state");
        if (state == null) {
            this.renderErrorPage(400, "state-parameter is missing", resp);
            return;
        }
        try {
            Object connector = this.connectorService.getConnectorByUniqueId(state).getConnector();
            if (!(connector instanceof OAuthAuthorizationCodeFlow)) {
                this.renderErrorPage(400, "Connector is no AuthorizationCodeConnector", resp);
            } else if (code == null) {
                this.renderErrorPage(400, "Parameter code is missing in request", resp);
            } else {
                OAuthAuthorizationCodeFlow oAuthAuthorizationCodeFlow = (OAuthAuthorizationCodeFlow)connector;
                oAuthAuthorizationCodeFlow.requestAccessToken(code);
                this.renderPage(200, true, "Authorization was successful. Please close this window, return to the connector configuration page, and close the modal to proceed with synchronization.", resp);
            }
        }
        catch (ConnectorNotFoundException e) {
            this.renderErrorPage(400, "Connector was not found", resp);
        }
        catch (ConnectorFactoryNotAvailableException e) {
            logger.warn("Connector Factory is not available", (Throwable)e);
            this.renderErrorPage(500, "Connector Factory not available", resp);
        }
        catch (ConfigurationFailedException e) {
            logger.warn("Connector Configuration failed", (Throwable)e);
            this.renderErrorPage(500, "Connector Configuration failed", resp);
        }
        catch (AccessTokenException e) {
            this.renderErrorPage(500, "Failed to request access token: " + e.getMessage(), resp);
        }
    }
}

