/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.oauth;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.resolution.reconfigure.Utils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOAuthServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthServlet.class);
    private final TemplateRenderer templateRenderer;
    private final String loadedTemplate;

    AbstractOAuthServlet(@ComponentImport TemplateRenderer templateRenderer, String pathToVelocityTemplate) {
        this.templateRenderer = templateRenderer;
        this.loadedTemplate = Utils.readFromClasspath(pathToVelocityTemplate);
    }

    protected void renderErrorPage(int status, String message, HttpServletResponse servletResponse) {
        this.renderPage(status, false, message, servletResponse);
    }

    protected void renderPage(int status, boolean success, String message, HttpServletResponse servletResponse) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("message", message);
        ctx.put("success", success);
        String responseData = this.templateRenderer.renderFragment(this.loadedTemplate, ctx);
        servletResponse.setStatus(status);
        try {
            servletResponse.getWriter().write(responseData);
        }
        catch (IOException e) {
            logger.error("IOException getting writer for the ServletResponse!", (Throwable)e);
        }
    }
}

