/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.confluence;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import de.resolution.usersync.api.SharedHomeProvider;
import de.resolution.usersync.impl.ClusterNodeInformation;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
@ExportAsService(value={SharedHomeProvider.class, ClusterNodeInformation.class})
public class ConfluenceClusterNodeInformation
implements ClusterNodeInformation,
SharedHomeProvider {
    private final String nodeName;
    private final File sharedHome;
    private final ClusterManager clusterManager;
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceClusterNodeInformation.class);

    @Inject
    public ConfluenceClusterNodeInformation(@ConfluenceImport ClusterManager clusterManager, @ConfluenceImport BootstrapManager bootstrapManager) {
        com.atlassian.confluence.cluster.ClusterNodeInformation clusterNodeInformation;
        this.nodeName = clusterManager.isClustered() ? ((clusterNodeInformation = clusterManager.getThisNodeInformation()) != null ? clusterNodeInformation.getAnonymizedNodeIdentifier() : "NOT_CLUSTERED") : "NOT_CLUSTERED";
        this.sharedHome = bootstrapManager.getSharedHome();
        this.clusterManager = clusterManager;
    }

    @Override
    public String getNodeId() {
        return this.nodeName;
    }

    @Override
    public Set<String> getAllNodeIds() {
        if (this.nodeName.equals("NOT_CLUSTERED")) {
            return Collections.singleton("NOT_CLUSTERED");
        }
        Set<String> allNodes = this.clusterManager.getAllNodesInformation().stream().map(com.atlassian.confluence.cluster.ClusterNodeInformation::getAnonymizedNodeIdentifier).collect(Collectors.toSet());
        if (logger.isDebugEnabled()) {
            logger.debug("Cluster nodes: {}", (Object)String.join((CharSequence)",", allNodes));
        }
        return allNodes;
    }

    @Override
    public Set<String> getActiveNodeIds() {
        return this.getAllNodeIds();
    }

    @Override
    public File getSharedHome() {
        return this.sharedHome;
    }

    @Override
    public ClusterNodeInformation.Product getProduct() {
        return ClusterNodeInformation.Product.CONFLUENCE;
    }
}

