/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.bitbucket;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import de.resolution.usersync.api.SharedHomeProvider;
import de.resolution.usersync.impl.ClusterNodeInformation;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

@BitbucketComponent
@ExportAsService(value={SharedHomeProvider.class, ClusterNodeInformation.class})
public class BitbucketClusterNodeInformation
implements ClusterNodeInformation,
SharedHomeProvider {
    private final File sharedHome;
    private final String nodeId;
    private final ClusterService clusterService;

    @Inject
    BitbucketClusterNodeInformation(@BitbucketImport StorageService storageService, @BitbucketImport ClusterService clusterService) {
        this.sharedHome = storageService.getSharedHomeDir().toFile();
        ClusterInformation clusterInformation = clusterService.getInformation();
        this.nodeId = clusterInformation.isRunning() ? clusterInformation.getLocalNode().getId() : "NOT_CLUSTERED";
        this.clusterService = clusterService;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public Set<String> getAllNodeIds() {
        if (this.nodeId.equals("NOT_CLUSTERED")) {
            return Collections.singleton("NOT_CLUSTERED");
        }
        return this.clusterService.getInformation().getNodes().stream().map(ClusterNode::getId).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getActiveNodeIds() {
        if (this.nodeId.equals("NOT_CLUSTERED")) {
            return Collections.singleton("NOT_CLUSTERED");
        }
        return this.clusterService.getInformation().getNodes().stream().filter(ClusterNode::isFullyStarted).map(ClusterNode::getId).collect(Collectors.toSet());
    }

    @Override
    public File getSharedHome() {
        return this.sharedHome;
    }

    @Override
    public ClusterNodeInformation.Product getProduct() {
        return ClusterNodeInformation.Product.BITBUCKET;
    }
}

