/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.bamboo;

import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.resolution.usersync.impl.UserSyncXsrfCheckAvoider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Objects;

@BambooComponent
@ExportAsService(value={UserSyncXsrfCheckAvoider.class})
public class BambooUserSyncXsrfCheckAvoider
implements UserSyncXsrfCheckAvoider {
    @Override
    public void avoidXsrfCheck() {
        final HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        if (request != null && Objects.equals(request.getMethod(), "GET") && !Objects.equals(request.getHeader("X-Atlassian-Token"), "no-check")) {
            HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request){

                public String getHeader(String name) {
                    if ("X-Atlassian-Token".equals(name)) {
                        return "no-check";
                    }
                    return request.getHeader(name);
                }
            };
            RequestCacheThreadLocal.update((HttpServletRequest)requestWrapper);
        }
    }
}

