/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.bamboo;

import com.atlassian.bamboo.beehive.BambooClusterNodeHeartbeatService;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.usersync.impl.ClusterNodeInformation;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
@ExportAsService(value={ClusterNodeInformation.class})
public class BambooClusterNodeInformation
implements ClusterNodeInformation {
    private static final Logger logger = LoggerFactory.getLogger(BambooClusterNodeInformation.class);
    @Nullable
    private final BambooClusterNodeHeartbeatService bambooClusterNodeHeartbeatService;
    @Nonnull
    private final String nodeId;

    public BambooClusterNodeInformation() {
        BambooClusterNodeHeartbeatService nodeHeartbeatService = (BambooClusterNodeHeartbeatService)ComponentLocator.getComponent(BambooClusterNodeHeartbeatService.class);
        if (nodeHeartbeatService != null) {
            logger.debug("Located BambooClusterNodeHeartbeatService");
            this.bambooClusterNodeHeartbeatService = nodeHeartbeatService;
            this.nodeId = this.bambooClusterNodeHeartbeatService.getNodeId();
        } else {
            logger.debug("No BambooClusterNodeHeartbeatService found, assuming this is no DC deployment.");
            this.bambooClusterNodeHeartbeatService = null;
            this.nodeId = "NOT_CLUSTERED";
        }
    }

    @Override
    @Nonnull
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    @Nonnull
    public Set<String> getAllNodeIds() {
        if (this.bambooClusterNodeHeartbeatService == null) {
            logger.debug("No ClusterService, assuming this is a single node.");
            return Collections.singleton(this.nodeId);
        }
        HashSet<String> nodeIds = new HashSet<String>(this.bambooClusterNodeHeartbeatService.findLiveNodes());
        if (logger.isDebugEnabled()) {
            logger.debug("Node IDs are {}", (Object)String.join((CharSequence)",", nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Set<String> getActiveNodeIds() {
        return Collections.singleton(this.getNodeId());
    }

    @Override
    public ClusterNodeInformation.Product getProduct() {
        return ClusterNodeInformation.Product.BAMBOO;
    }
}

