/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.NotificationService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VolatileNotificationServiceImpl
implements NotificationService {
    private final Map<String, Map<String, Notification>> notificationMap = new HashMap<String, Map<String, Notification>>();

    @Override
    public void add(@Nonnull Notification notification) {
        Map currentConnectorMap = this.notificationMap.computeIfAbsent(notification.getContextId(), k -> new HashMap());
        currentConnectorMap.put(notification.getMessageId(), notification);
    }

    @Override
    @Nullable
    public Notification get(@Nonnull String contextId, @Nonnull String msgId) {
        Map<String, Notification> currentConnectorMap = this.notificationMap.get(contextId);
        if (currentConnectorMap == null) {
            return null;
        }
        return currentConnectorMap.get(msgId);
    }

    @Override
    public List<Notification> getAll() {
        ArrayList<Notification> ret = new ArrayList<Notification>();
        for (Map.Entry<String, Map<String, Notification>> current : this.notificationMap.entrySet()) {
            ret.addAll(current.getValue().values());
        }
        return ret;
    }

    @Override
    public List<Notification> getAll(String contextId) {
        return new ArrayList<Notification>(this.notificationMap.computeIfAbsent(contextId, k -> Collections.emptyMap()).values());
    }

    @Override
    public void ack(String contextId, @Nonnull String messageId) {
        Map<String, Notification> mapPerConnector = this.notificationMap.get(contextId);
        if (mapPerConnector != null) {
            mapPerConnector.remove(messageId);
        }
    }
}

