/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.resolution.commons.task.api.Task;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.heartbeat.HeartbeatReceiver;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.security.SecureRandom;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named(value="syncStatusCheck")
public class SyncStatusCheck
implements JobRunner,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SyncStatusCheck.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)SyncStatusCheck.class.getCanonicalName());
    private final JobId jobId = JobId.of((String)"de.resolution.usersync.impl.SyncStatusCheck");
    private static final Random RANDOM = new SecureRandom();
    private final SyncStatusRepository syncStatusRepository;
    private final HeartbeatReceiver heartbeatReceiver;
    private final SchedulerService schedulerService;
    public static final long MAX_HEARTBEAT_AGE = 100000L;

    @Inject
    public SyncStatusCheck(SyncStatusRepository syncStatusRepository, HeartbeatReceiver heartbeatReceiver, @ComponentImport SchedulerService schedulerService) {
        this.syncStatusRepository = syncStatusRepository;
        this.heartbeatReceiver = heartbeatReceiver;
        this.schedulerService = schedulerService;
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.scheduleSyncStatusCheck();
    }

    public void scheduleSyncStatusCheck() {
        Date firstRun = new Date(System.currentTimeMillis() + 15000L + (long)RANDOM.nextInt(10000));
        int intervalInMillis = 60000;
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(Schedule.forInterval((long)60000L, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            logger.info("Scheduling SyncStatus check Job {} with the interval {}, first run is {} ", new Object[]{this.jobId, 60000, firstRun});
            this.schedulerService.scheduleJob(this.jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            logger.error("Scheduling SyncStatus check job failed!", (Throwable)e);
        }
    }

    public void destroy() {
        logger.debug("Unscheduling job {}", (Object)this.jobId);
        this.schedulerService.unscheduleJob(this.jobId);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        this.checkForRunningSyncs();
        return JobRunnerResponse.success();
    }

    public void checkForRunningSyncs() {
        logger.debug("Checking SyncStatus...");
        List<SyncStatus> runningSyncs = this.syncStatusRepository.getRunningOrNew();
        if (runningSyncs.isEmpty()) {
            logger.debug("No running syncs, done here.");
            return;
        }
        long now = System.currentTimeMillis();
        for (SyncStatus runningSync : runningSyncs) {
            long age;
            long last = this.heartbeatReceiver.getLastHeartbeat(runningSync.getId());
            if (last < 0L) {
                last = runningSync.getCreatedTime();
            }
            if ((age = now - last) > 100000L) {
                logger.warn("Sync {} has not sent a heartbeat for {} ms, setting it to DEAD", (Object)runningSync.getId(), (Object)age);
                runningSync.cancel();
                runningSync.setStatus(Task.Status.DEAD);
                runningSync.addMessage("Sync has not sent a heartbeat for " + age + " ms, setting it to DEAD");
                continue;
            }
            logger.debug("Sync {} is still alive, last heartbeat was {} ms ago", (Object)runningSync.getId(), (Object)age);
        }
        this.heartbeatReceiver.cleanup();
        logger.debug("SyncStatus check done.");
    }
}

