/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import de.resolution.usersync.api.Notification;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class NotificationImpl
implements Notification {
    private final Notification.Level level;
    private final String message;
    private final String messageId;
    private final String contextId;
    private final long createdAt;

    public NotificationImpl(@Nonnull String message, @Nonnull Notification.Level level, @Nonnull String messageId, @Nonnull String contextId) {
        this(message, level, messageId, contextId, System.currentTimeMillis());
    }

    public NotificationImpl(@Nonnull String message, @Nonnull Notification.Level level, @Nonnull String messageId, @Nonnull String contextId, long createdAt) {
        this.messageId = Objects.requireNonNull(messageId);
        this.level = Objects.requireNonNull(level);
        this.message = Objects.requireNonNull(message);
        this.contextId = Objects.requireNonNull(contextId);
        this.createdAt = createdAt;
    }

    @Override
    public Notification.Level getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationImpl that = (NotificationImpl)o;
        return Objects.equals(this.contextId, that.contextId) && this.level == that.level && this.message.equals(that.message) && this.messageId.equals(that.messageId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.message, this.messageId, this.contextId, this.createdAt});
    }
}

