/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.usersync.api.ConnectorStorageManager;
import de.resolution.usersync.impl.AoConnectorStorageElement;
import de.resolution.usersync.impl.AoLegacyConnectorStorageElement;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ConnectorStorageManagerImpl
implements ConnectorStorageManager {
    private final ActiveObjects ao;
    private static final String SEARCH_QUERY = "CONN_UID = ? AND KEY = ?";

    @Inject
    public ConnectorStorageManagerImpl(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Optional<String> get(String connectorUID, String key) {
        return (Optional)this.ao.executeInTransaction(() -> {
            AoConnectorStorageElement[] elements = (AoConnectorStorageElement[])this.ao.find(AoConnectorStorageElement.class, SEARCH_QUERY, new Object[]{connectorUID, key});
            if (elements == null || elements.length == 0) {
                return Optional.empty();
            }
            return Optional.ofNullable(elements[0].getValue());
        });
    }

    @Override
    public void set(String connectorUID, String key, String value) {
        this.ao.executeInTransaction(() -> {
            AoConnectorStorageElement[] elements = (AoConnectorStorageElement[])this.ao.find(AoConnectorStorageElement.class, SEARCH_QUERY, new Object[]{connectorUID, key});
            if (elements.length == 0) {
                return (AoConnectorStorageElement)this.ao.create(AoConnectorStorageElement.class, new DBParam[]{new DBParam("CONN_UID", (Object)connectorUID), new DBParam("KEY", (Object)key), new DBParam("VALUE", (Object)value)});
            }
            elements[0].setValue(value);
            elements[0].save();
            return elements[0];
        });
    }

    @Override
    public boolean remove(String connectorUID, String key) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            AoConnectorStorageElement[] elements = (AoConnectorStorageElement[])this.ao.find(AoConnectorStorageElement.class, SEARCH_QUERY, new Object[]{connectorUID, key});
            if (elements.length == 0) {
                return false;
            }
            this.ao.delete(new RawEntity[]{elements[0]});
            return true;
        });
    }

    @Override
    public Map<String, String> getAll(String connectorUID) {
        return (Map)this.ao.executeInTransaction(() -> {
            AoConnectorStorageElement[] elements = (AoConnectorStorageElement[])this.ao.find(AoConnectorStorageElement.class, "CONN_UID = ?", new Object[]{connectorUID});
            return Arrays.stream(elements).collect(Collectors.toMap(AoConnectorStorageElement::getKey, AoConnectorStorageElement::getValue));
        });
    }

    @Override
    public Map<String, String> getAllLegacy(int legacyConnectorId) {
        return (Map)this.ao.executeInTransaction(() -> {
            AoLegacyConnectorStorageElement[] elements = (AoLegacyConnectorStorageElement[])this.ao.find(AoLegacyConnectorStorageElement.class, "CONNECTOR_ID = ?", new Object[]{legacyConnectorId});
            return Arrays.stream(elements).collect(Collectors.toMap(AoLegacyConnectorStorageElement::getKey, AoLegacyConnectorStorageElement::getValue));
        });
    }

    @Override
    public int removeAll(String connectorUID) {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(AoConnectorStorageElement.class, "CONN_UID = ?", new Object[]{connectorUID}));
    }
}

