/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.heartbeat.HeartbeatReceiver;
import de.resolution.usersync.heartbeat.HeartbeatSender;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
public class LocalHeartbeatSender
implements HeartbeatSender {
    private static final Logger logger = LoggerFactory.getLogger(LocalHeartbeatSender.class);
    private final HeartbeatReceiver heartbeatReceiver;

    @Inject
    public LocalHeartbeatSender(HeartbeatReceiver heartbeatReceiver) {
        this.heartbeatReceiver = heartbeatReceiver;
    }

    @Nonnull
    public static String createMessage(int syncStatusId, long timestamp) {
        return syncStatusId + ":" + timestamp;
    }

    @Override
    public long sendHeartbeat(@Nonnull SyncStatus syncStatus) {
        long timestamp = System.currentTimeMillis();
        logger.trace("Sending Heartbeat: DUCK! {}:{}", (Object)syncStatus.getId(), (Object)timestamp);
        this.heartbeatReceiver.addHeartbeat(syncStatus.getId(), timestamp);
        return timestamp;
    }
}

