/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import de.resolution.usersync.heartbeat.HeartbeatReceiver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
public class LocalHeartbeatReceiver
implements HeartbeatReceiver {
    private static final Logger logger = LoggerFactory.getLogger(LocalHeartbeatReceiver.class);
    private final Map<Integer, Long> lastHeartbeat = new ConcurrentHashMap<Integer, Long>();
    private static final long MAX_AGE = 600000L;

    @Nullable
    public static IdAndTimestamp splitMessage(@Nonnull String message) {
        String[] parts = message.split(":");
        if (parts.length != 2) {
            logger.warn("Unexpected message format: {}", (Object)message);
            return null;
        }
        String syncStatusIdString = parts[0];
        String timestampString = parts[1];
        try {
            long timestamp = Long.parseLong(timestampString);
            int syncStatusId = Integer.parseInt(syncStatusIdString);
            return new IdAndTimestamp(syncStatusId, timestamp);
        }
        catch (NumberFormatException e) {
            logger.warn("Invalid timestamp format: {}", (Object)timestampString);
            return null;
        }
    }

    @Override
    public void addHeartbeat(int syncStatusId, long timestamp) {
        logger.trace("Received Heartbeat: GOOSE! {}:{}", (Object)syncStatusId, (Object)timestamp);
        Long existing = this.lastHeartbeat.get(syncStatusId);
        if (existing == null || existing < timestamp) {
            this.lastHeartbeat.put(syncStatusId, timestamp);
        }
    }

    @Override
    public long getLastHeartbeat(int syncStatusId) {
        Long lastTimestamp = this.lastHeartbeat.get(syncStatusId);
        return lastTimestamp == null ? -1L : lastTimestamp;
    }

    @Override
    public void cleanup() {
        long now = System.currentTimeMillis();
        this.lastHeartbeat.keySet().removeIf(key -> now - this.lastHeartbeat.get(key) > 600000L);
    }

    public static class IdAndTimestamp {
        private final int id;
        private final long timestamp;

        public IdAndTimestamp(int id, long timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public int getId() {
            return this.id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

