/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.heartbeat.HeartbeatReceiver;
import de.resolution.usersync.heartbeat.LocalHeartbeatSender;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.Objects;

@JiraComponent
public class JiraHeartbeatSender
extends LocalHeartbeatSender {
    private final ClusterMessagingService clusterMessagingService = Objects.requireNonNull((ClusterMessagingService)ComponentAccessor.getComponent(ClusterMessagingService.class));

    @Inject
    public JiraHeartbeatSender(HeartbeatReceiver heartbeatReceiver) {
        super(heartbeatReceiver);
    }

    @Override
    public long sendHeartbeat(@Nonnull SyncStatus syncStatus) {
        long timestamp = super.sendHeartbeat(syncStatus);
        String message = LocalHeartbeatSender.createMessage(syncStatus.getId(), timestamp);
        this.clusterMessagingService.sendRemote("usersync.heartbeat", message);
        return timestamp;
    }
}

