/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import de.resolution.usersync.heartbeat.BitbucketHeartbeatSender;
import de.resolution.usersync.heartbeat.LocalHeartbeatReceiver;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.springframework.beans.factory.DisposableBean;

@BitbucketComponent
public class BitbucketHeartbeatReceiver
extends LocalHeartbeatReceiver
implements TopicListener<String>,
DisposableBean {
    private final Topic<String> topic;
    private final String topicSubscriptionId;

    @Inject
    public BitbucketHeartbeatReceiver(@BitbucketImport TopicService topicService) {
        this.topic = topicService.getTopic("usersync.heartbeat", BitbucketHeartbeatSender.TOPIC_SETTINGS);
        this.topicSubscriptionId = this.topic.subscribe((TopicListener)this);
    }

    public void onMessage(@Nonnull MessageEvent<String> messageEvent) {
        if (messageEvent.getSource().isLocal()) {
            return;
        }
        String message = (String)messageEvent.getMessage();
        LocalHeartbeatReceiver.IdAndTimestamp idAndTimestamp = LocalHeartbeatReceiver.splitMessage(message);
        if (idAndTimestamp != null) {
            this.addHeartbeat(idAndTimestamp.getId(), idAndTimestamp.getTimestamp());
        }
    }

    public void destroy() throws Exception {
        this.topic.unsubscribe(this.topicSubscriptionId);
    }
}

