/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.testconnector;

import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.impl.SimpleCancelHandle;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfiguration;
import de.resolution.usersync.builtin.testconnector.TestUserCreator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/testdata")
public class TestConnectorRestResource {
    private final PrivilegeChecker privilegeChecker;

    @Inject
    public TestConnectorRestResource(PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Path(value="/")
    public Response createTestdata(String testConnectorConfigurationJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        TestConnectorConfiguration testConnectorConfiguration = (TestConnectorConfiguration)JSONUtil.fromJson((String)testConnectorConfigurationJson, TestConnectorConfiguration.class);
        ListStructuredData testdata = TestUserCreator.createFakeUsers(testConnectorConfiguration.getCount(), testConnectorConfiguration.getGroupCount(), testConnectorConfiguration.getEmailDomain(), (CancelHandle)new SimpleCancelHandle());
        return Response.ok().entity((Object)JSONUtil.asJson((Object)testdata)).build();
    }
}

