/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.Tuple;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.builtin.scim.exception.ScimExceptionWrapper;
import de.resolution.usersync.builtin.scim.rest.AbstractResource;
import de.resolution.usersync.builtin.scim.rest.ListResponse;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import de.resolution.usersync.builtin.scim.rest.PatchRequest;
import de.resolution.usersync.builtin.scim.rest.ScimRequestUtils;
import de.resolution.usersync.builtin.scim.user.ScimCoreUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="usersync/connector/{connectorId}/scim/v2/Users")
@UnrestrictedAccess
@Component
public class UserResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);
    private static final String PATH_PARAM_USER_ID = "userId";
    private static final String MESSAGE_USER_ID_MUST_NOT_BE_EMPTY = "UserId must not be empty";

    @Inject
    public UserResource(@Nonnull ConnectorService connectorService, @Nonnull PrivilegeChecker privilegeChecker, @Nonnull LicenseChecker licenseChecker, @Nonnull SyncStatusRepository syncStatusRepository) {
        super(connectorService, privilegeChecker, licenseChecker, syncStatusRepository);
    }

    @Nonnull
    private Response logAndReturnResponse(@Nonnull Tuple<ScimCoreUser, AtlasUserResult.Operation> result, @Nonnull SyncStatusFacade syncStatusFacade) {
        Response.Status status = UserResource.operationToStatus((AtlasUserResult.Operation)result.right());
        String responseBody = JSONUtil.asJson((Object)result.left());
        if (syncStatusFacade.getSyncStatus() != null && syncStatusFacade.getSyncStatus().getSyncStatusResult() != SyncStatus.Result.FAILED && syncStatusFacade.getSyncStatus().getSyncStatusResult() != SyncStatus.Result.PARTIALLY_FAILED) {
            syncStatusFacade.getSyncStatus().setSyncStatusResult(SyncStatus.Result.SUCCESS);
        }
        return Response.status((Response.Status)status).entity((Object)responseBody).cacheControl(ccNoCache).build();
    }

    @Nonnull
    protected static Response.Status operationToStatus(@Nonnull AtlasUserResult.Operation operation) {
        switch (operation) {
            case ADDED: {
                return Response.Status.CREATED;
            }
            case UPDATED: 
            case NOT_MODIFIED: {
                return Response.Status.OK;
            }
            case FILTERED: 
            case DELETED: {
                return Response.Status.NO_CONTENT;
            }
            case FAILED: {
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    @GET
    @Produces(value={"application/json", "application/scim+json"})
    public Response getUsers(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="startIndex") int startIndex, @QueryParam(value="count") int count, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @QueryParam(value="filter") @Nullable String filter) throws ScimExceptionWrapper {
        return this.handleScimRequest(connectorId, request, null, false, (scimConnector, syncStatusFacade) -> {
            if (logger.isTraceEnabled()) {
                logger.trace("--> GET /Users/ - startIndex: {}, count: {}, filter: {}", new Object[]{startIndex, count, filter});
            }
            ListResponse listResponse = scimConnector.getUsers(ScimRequestUtils.parseStartIndex(startIndex), ScimRequestUtils.parseCount(count), ScimRequestUtils.parseFilter(filter), ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            if (logger.isTraceEnabled()) {
                logger.trace("Returned {} users", (Object)listResponse.getResources().size());
            }
            return Response.ok((Object)JSONUtil.asJson((Object)listResponse)).cacheControl(ccNoCache).build();
        });
    }

    @GET
    @Path(value="/{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response getUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes) throws ScimExceptionWrapper {
        return this.handleScimRequest(connectorId, request, null, false, (scimConnector, syncStatusFacade) -> {
            if (userId == null || userId.isEmpty()) {
                throw BadRequestException.noTarget((String)MESSAGE_USER_ID_MUST_NOT_BE_EMPTY);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("--> GET /Users/{} ", (Object)StringUtil.sanitize((String)userId));
            }
            ScimCoreUser scimUser = scimConnector.getUser(userId, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            if (logger.isTraceEnabled()) {
                logger.trace("Returned user with id {}", (Object)StringUtil.sanitize((String)userId));
            }
            return Response.ok((Object)JSONUtil.asJson((Object)scimUser)).cacheControl(ccNoCache).build();
        });
    }

    @POST
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response createUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimExceptionWrapper {
        return this.handleScimRequest(connectorId, request, resourceString, true, (scimConnector, syncStatusFacade) -> {
            if (resourceString == null || resourceString.isEmpty()) {
                throw BadRequestException.invalidValue((String)"Request contains no resource string");
            }
            StructuredData data = StructuredData.parseJson((String)resourceString);
            Tuple<ScimCoreUser, AtlasUserResult.Operation> result = scimConnector.createUser(data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            return this.logAndReturnResponse(result, syncStatusFacade);
        });
    }

    @PUT
    @Path(value="{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response updateUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimExceptionWrapper {
        return this.handleScimRequest(connectorId, request, resourceString, true, (scimConnector, syncStatusFacade) -> {
            if (userId == null || userId.isEmpty()) {
                throw BadRequestException.noTarget((String)MESSAGE_USER_ID_MUST_NOT_BE_EMPTY);
            }
            if (resourceString == null || resourceString.isEmpty()) {
                throw BadRequestException.invalidValue((String)"Request contains no resource string");
            }
            StructuredData data = StructuredData.parseJson((String)resourceString);
            Tuple<ScimCoreUser, AtlasUserResult.Operation> result = scimConnector.updateUser(userId, data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            return this.logAndReturnResponse(result, syncStatusFacade);
        });
    }

    @PATCH
    @Path(value="{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response patchUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimExceptionWrapper {
        return this.handleScimRequest(connectorId, request, resourceString, true, (scimConnector, syncStatusFacade) -> {
            if (StringUtil.isNullOrEmpty((String)userId)) {
                throw BadRequestException.noTarget((String)MESSAGE_USER_ID_MUST_NOT_BE_EMPTY);
            }
            if (StringUtil.isNullOrEmpty((String)resourceString)) {
                throw BadRequestException.invalidValue((String)"PATCH request did not contain any PATCH operations");
            }
            PatchRequest patchRequest = PatchRequest.fromJson(resourceString);
            HashMap<String, Object> attributesToUpdate = new HashMap<String, Object>();
            HashSet<StructuredData> groupsToAdd = new HashSet<StructuredData>();
            HashSet<StructuredData> groupsToRemove = new HashSet<StructuredData>();
            HashSet<StructuredData> groupsToReplace = new HashSet<StructuredData>();
            block9: for (PatchRequest.PatchOperation operation : patchRequest.getOperations()) {
                if ("groups".equalsIgnoreCase(operation.getPath())) {
                    switch (operation.getOp()) {
                        case ADD: {
                            StructuredData value = operation.getValue();
                            if (value.isList()) {
                                groupsToAdd.addAll((Collection<StructuredData>)value.asList());
                                continue block9;
                            }
                            groupsToAdd.add(value);
                            continue block9;
                        }
                        case REPLACE: {
                            StructuredData value = operation.getValue();
                            if (value.isList()) {
                                groupsToReplace.addAll((Collection<StructuredData>)value.asList());
                                continue block9;
                            }
                            groupsToReplace.add(value);
                            continue block9;
                        }
                        case REMOVE: {
                            StructuredData value = operation.getValue();
                            if (value.isList()) {
                                groupsToRemove.addAll((Collection<StructuredData>)value.asList());
                                continue block9;
                            }
                            groupsToRemove.add(value);
                            continue block9;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operation.getOp()));
                        }
                    }
                }
                switch (operation.getOp()) {
                    case ADD: 
                    case REPLACE: {
                        attributesToUpdate.put(operation.getPath(), operation.getValue());
                        continue block9;
                    }
                    case REMOVE: {
                        attributesToUpdate.put(operation.getPath(), StructuredData.create());
                        continue block9;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operation.getOp()));
            }
            if (!CollectionUtil.isNullOrEmpty(groupsToReplace)) {
                attributesToUpdate.put("groups", new ListStructuredData(groupsToReplace));
            }
            Tuple<ScimCoreUser, AtlasUserResult.Operation> result = scimConnector.patchUser(userId, (StructuredData)StructuredData.create(attributesToUpdate), groupsToAdd, groupsToRemove, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            return this.logAndReturnResponse(result, syncStatusFacade);
        });
    }

    @DELETE
    @Path(value="/{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response deleteUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId) throws ScimExceptionWrapper {
        return this.handleScimRequest(connectorId, request, null, true, (scimConnector, syncStatusFacade) -> {
            if (userId == null || userId.isEmpty()) {
                throw BadRequestException.noTarget((String)MESSAGE_USER_ID_MUST_NOT_BE_EMPTY);
            }
            scimConnector.deleteUser(userId, syncStatusFacade);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(ccNoCache).build();
        });
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response getUsersByPost(String resourceString) throws ScimExceptionWrapper {
        throw new ScimExceptionWrapper((ScimException)new NotImplementedException("This endpoint is not implemented"), null);
    }
}

