/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ErrorResponse;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.builtin.scim.exception.ScimExceptionWrapper;
import de.resolution.usersync.builtin.scim.rest.ScimErrorResponseBuilder;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class ScimExceptionMapper
implements ExceptionMapper<ScimExceptionWrapper> {
    private static final Logger logger = LoggerFactory.getLogger(ScimExceptionMapper.class);
    private final SyncStatusRepository syncStatusRepository;

    @Autowired
    public ScimExceptionMapper(@Nonnull SyncStatusRepository syncStatusRepository) {
        this.syncStatusRepository = syncStatusRepository;
    }

    @Nonnull
    public Response toResponse(@Nonnull ScimExceptionWrapper e) {
        Optional<SyncStatusAoProxy> optionalSyncStatusAoProxy;
        ScimException scimException = e.getScimException();
        String errorMessage = "SCIM request failed: " + scimException.getMessage() + ", errorType: " + JSONUtil.asJson((Object)scimException.getScimError());
        Optional<Integer> syncStatusId = e.getSyncStatusId();
        if (syncStatusId.isPresent() && (optionalSyncStatusAoProxy = this.syncStatusRepository.get(syncStatusId.get())).isPresent()) {
            SyncStatusAoProxy syncStatusAoProxy = optionalSyncStatusAoProxy.get();
            syncStatusAoProxy.setSyncStatusResult(SyncStatus.Result.PARTIALLY_FAILED);
            if (logger.isDebugEnabled()) {
                syncStatusAoProxy.addMessage(errorMessage);
            }
        }
        ErrorResponse scimError = scimException.getScimError();
        ScimErrorResponseBuilder builder = new ScimErrorResponseBuilder().status(scimError.getStatus()).detail(scimException.getMessage());
        if (!StringUtil.isNullOrEmpty((String)scimError.getScimType())) {
            builder.scimType(scimError.getScimType());
        }
        if (scimException instanceof ResourceNotFoundException) {
            if (logger.isDebugEnabled()) {
                logger.debug(errorMessage, (Throwable)e);
            }
        } else if (logger.isErrorEnabled()) {
            logger.error(errorMessage, (Throwable)e);
        }
        return builder.build();
    }
}

