/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.okta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.okta.OktaConnector;
import de.resolution.usersync.builtin.okta.OktaConnectorConfiguration;
import de.resolution.usersync.builtin.okta.OktaConnectorConfigurationImpl;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractHTTPConnectorFactory;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;

@Named(value="oktaConnectorFactory")
@JsonAutoDetect
public class OktaConnectorFactory
extends AbstractHTTPConnectorFactory<OktaConnector, OktaConnectorConfiguration> {
    @Inject
    public OktaConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
    }

    @Override
    @Nonnull
    public OktaConnector create(@Nonnull OktaConnectorConfiguration oktaConnectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new OktaConnector(this.connectorService, this.atlasUserAdapter, oktaConnectorConfiguration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public OktaConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        OktaConnectorConfigurationImpl mutableConfig = new OktaConnectorConfigurationImpl();
        mutableConfig.setName("new Okta");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public Class<OktaConnector> getConnectorClass() {
        return OktaConnector.class;
    }

    @Override
    @Nonnull
    public Class<OktaConnectorConfiguration> getConfigurationClass() {
        return OktaConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Okta";
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "This is a connector for Okta using the Okta REST API.";
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editOktaConnector.json";
    }

    @Override
    protected void migrateSpecificConfigurationToVersion2(ObjectNode configurationNode, List<AttributeTransformationConfig> attributeTransformationConfigs) {
        attributeTransformationConfigs.add(OktaConnectorConfigurationImpl.ACTIVE_TRANSFORMATION);
    }

    @Override
    public String getSingleSyncInputTitle() {
        return "Okta Identifier";
    }

    @Override
    public String getSingleSyncInputDescription() {
        return "Please enter the email address of the Okta user to update. You can also only enter the local part of the email depending on your Okta configuration.";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull OktaConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        if (config.getApiToken().isEmpty()) {
            validationResult.add("apiToken", "API Token must be set");
        }
        String oktaDomainStr = "oktaDomain";
        if (config.getOktaDomain().isEmpty()) {
            validationResult.add("oktaDomain", "Okta Domain must be set");
        } else if (config.getOktaDomain().startsWith("https://")) {
            validationResult.add("oktaDomain", "You must enter your Okta domain without 'https://'");
        } else if (config.getOktaDomain().endsWith("/")) {
            validationResult.add("oktaDomain", "You must enter your Okta domain without a '/' at the end");
        }
        if (config.getRateLimitThreshold() < 0) {
            validationResult.add("rateLimitThreshold", "Must be 0 or greater");
        }
        return validationResult;
    }
}

