/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.okta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.okta.OktaConnector;
import de.resolution.usersync.builtin.okta.OktaConnectorConfiguration;
import de.resolution.usersync.spi.AbstractHTTPConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class OktaConnectorConfigurationImpl
extends AbstractHTTPConnectorConfigurationImpl
implements OktaConnectorConfiguration {
    @Nonnull
    private String oktaDomain = "";
    @Nonnull
    private String apiToken = "";
    private int rateLimitThreshold = 70;
    private int pageSize = 200;
    private static final String DEFAULT_FIND_BY_ATTRIBUTE_NAME = "okta_ID";
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();
    public static final AttributeTransformationConfig ACTIVE_TRANSFORMATION = new AttributeTransformationConfig(Source.createGroovy((String)"status !in [\"STAGED\",\"SUSPENDED\"]"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true);

    public OktaConnectorConfigurationImpl() {
    }

    public OktaConnectorConfigurationImpl(OktaConnectorConfiguration other) {
        super(other);
        this.setOktaDomain(other.getOktaDomain());
        this.setApiToken(other.getApiToken());
        this.setRateLimitThreshold(other.getRateLimitThreshold());
        this.setPageSize(other.getPageSize());
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return DEFAULT_FIND_BY_ATTRIBUTE_NAME;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public OktaConnectorConfiguration sanitize() {
        OktaConnectorConfigurationImpl copy = new OktaConnectorConfigurationImpl(this);
        copy.setApiToken("<<SENSITIVE DATA REMOVED>>");
        return copy;
    }

    @Override
    @Nonnull
    public String getOktaDomain() {
        return this.oktaDomain;
    }

    public void setOktaDomain(String oktaDomain) {
        if (oktaDomain != null) {
            this.oktaDomain = oktaDomain;
        }
    }

    @Override
    @Nonnull
    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        if (apiToken != null) {
            this.apiToken = apiToken;
        }
    }

    @Override
    public int getRateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    public void setRateLimitThreshold(int rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return OktaConnector.class;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"profile.login"), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createFieldCombiner((String)"{profile.firstName} {profile.lastName}"), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"profile.email"), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"id"), new Target(Target.Type.CROWD, DEFAULT_FIND_BY_ATTRIBUTE_NAME), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(GROUP_TRANSFORMATION);
        DEFAULT_TRANSFORMATION_CONFIGS.add(ACTIVE_TRANSFORMATION);
    }
}

