/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.okta;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPRequestFailedException;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.RequestFailedException;
import de.resolution.usersync.builtin.okta.OktaConnectorConfiguration;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.impl.requiredgroups.ServerFilterBasedRequiredGroupChecker;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractHTTPConnector;
import groovy.lang.Script;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaConnector
extends AbstractHTTPConnector<OktaConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(OktaConnector.class);
    public static final String OKTA_ATTRIBUTE_ID = "okta_ID";
    public static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    public static final String PATH_SEGMENT_USERS = "users";
    public static final String PATH_SEGMENT_GROUPS = "groups";
    public static final String PARAMETER_LIMIT = "limit";
    public static final String STATUS = "status";
    public static final Script STATUS_EXPRESSION = StructuredData.prepareFind((String)"status");
    public static final Script OKTA_ATTRIBUTE_ID_EXPRESSION = StructuredData.prepareFind((String)"id");
    public static final Pattern HEADER_LINK_REGEX = Pattern.compile("<(.*)>; rel=\"next\"");
    public static final String STATUS_DEPROVISIONED = "DEPROVISIONED";
    private static final Random RANDOM = new SecureRandom();
    private static final List<String> CONNECTOR_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("id", "status", "activated", "statusChanged", "lastLogin", "lastUpdated", "passwordChanged", "profile.login", "profile.firstName", "profile.lastName", "profile.nickName", "profile.displayName", "profile.email", "profile.secondEmail", "profile.profileUrl", "profile.preferredLanguage", "profile.userType", "profile.organization", "profile.title", "profile.division", "profile.department", "profile.costCenter", "profile.employeeNumber", "profile.mobilePhone", "profile.primaryPhone", "profile.streetAddress", "profile.city", "profile.state", "profile.zipCode", "profile.countryCode", "GROUPS"));

    OktaConnector(ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, OktaConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/OktaConnector.json");
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        if (this.getRequiredGroupCheckerHolder().hasRequiredGroupsConfigured()) {
            this.fetchUsersFromRequiredGroups(syncFunction, syncStatusFacade);
        } else {
            this.fetchAllUsers(syncFunction, syncStatusFacade);
        }
    }

    @Override
    @Nonnull
    public FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        HttpUrl url = this.getUsersUrlBase().addPathSegment(identifier).build();
        ResponseWrapper oktaResponse = this.performGetRequest(url.toString(), true, syncStatusFacade);
        if (oktaResponse.isNotFound()) {
            return FindUserResult.notFound();
        }
        if (!oktaResponse.isSuccess()) {
            return FindUserResult.failed(oktaResponse.getMessage());
        }
        StructuredData userAttributes = oktaResponse.getBodyAsStructuredData();
        if (STATUS_DEPROVISIONED.equals(userAttributes.findString(STATUS_EXPRESSION))) {
            return FindUserResult.notFound();
        }
        String userIdentifier = userAttributes.findString(OKTA_ATTRIBUTE_ID_EXPRESSION);
        if (userIdentifier == null) {
            return FindUserResult.failed("userIdentifier is null, that's unexpected here.");
        }
        try {
            Set<ConnectorGroup> groupsForUser = this.fetchGroupsForUser(userIdentifier, syncStatusFacade);
            Set<String> groupsNamesForUser = groupsForUser.stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.toSet());
            userAttributes.put((Object)"GROUPS", groupsNamesForUser);
            if (!((OktaConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync()) {
                if (((OktaConnectorConfiguration)this.configuration).isUseRequiredConnectorGroupsServerFilter() && !this.isUserInRequiredServerGroup(groupsNamesForUser, syncStatusFacade)) {
                    return FindUserResult.preFiltered(userAttributes);
                }
                if (!this.matchesLocalRequiredGroupChecker(groupsForUser)) {
                    return FindUserResult.preFiltered(userAttributes);
                }
            }
            return FindUserResult.found(userAttributes);
        }
        catch (HTTPRequestFailedException e) {
            return FindUserResult.failed((Exception)((Object)e));
        }
    }

    private boolean isUserInRequiredServerGroup(Set<String> assignedGroups, SyncStatusFacade syncStatusFacade) {
        Set<ConnectorGroup> connectorGroups = this.fetchRequiredConnectorGroups(this.getRequiredGroupCheckerHolder(), syncStatusFacade, groupsToTest -> groupsToTest.stream().map(ConnectorGroup::getName).anyMatch(assignedGroups::contains));
        return connectorGroups.stream().map(ConnectorGroup::getName).anyMatch(assignedGroups::contains);
    }

    public void fetchAllUsers(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.add("No required groups set, syncing all users.", SyncStatusFacade.LogLevel.DEBUG, logger);
        HttpUrl nextPageUrl = null;
        do {
            int resultCount;
            HttpUrl url;
            if (nextPageUrl == null) {
                url = this.getUsersUrlBase().addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build();
            } else {
                logger.debug("Fetching next page of users.");
                url = nextPageUrl;
            }
            ResponseWrapper response = this.syncUsersPage(url, syncFunction, syncStatusFacade, new HashSet<String>());
            nextPageUrl = OktaConnector.parseNextPageUrl(response);
            SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
            if (syncStatus == null || (resultCount = syncStatus.getResultCount()) % 100 != 0) continue;
            this.trackMemoryUsage(syncStatusFacade, "after processing " + resultCount + " users");
        } while (syncStatusFacade.isRunning() && nextPageUrl != null);
    }

    public void fetchUsersFromRequiredGroups(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        Set requiredGroupIds;
        try {
            requiredGroupIds = this.fetchRequiredConnectorGroups(this.getRequiredGroupCheckerHolder(), syncStatusFacade).stream().map(ConnectorGroup::getId).collect(Collectors.toSet());
        }
        catch (RequiredGroupCheckFailedException e) {
            syncStatusFacade.fail(e, logger);
            return;
        }
        syncStatusFacade.add("Syncing members of " + requiredGroupIds.size() + " groups", SyncStatusFacade.LogLevel.DEBUG, logger);
        if (!syncStatusFacade.isRunning()) {
            return;
        }
        HashSet<String> seenUserIdentifiers = new HashSet<String>();
        for (String requiredGroupId : requiredGroupIds) {
            HttpUrl nextPageUrl = null;
            do {
                int resultCount;
                HttpUrl url = nextPageUrl == null ? this.getGroupsUrlBase().addPathSegment(requiredGroupId).addPathSegment(PATH_SEGMENT_USERS).addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build() : nextPageUrl;
                ResponseWrapper response = this.syncUsersPage(url, syncFunction, syncStatusFacade, seenUserIdentifiers);
                nextPageUrl = OktaConnector.parseNextPageUrl(response);
                SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
                if (syncStatus == null || (resultCount = syncStatus.getResultCount()) % 100 != 0) continue;
                this.trackMemoryUsage(syncStatusFacade, "after processing " + resultCount + " users");
            } while (syncStatusFacade.isRunning() && nextPageUrl != null);
            if (syncStatusFacade.isRunning()) continue;
            return;
        }
    }

    public ResponseWrapper syncUsersPage(@Nonnull HttpUrl url, @Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade, @Nonnull Set<String> seenUserIdentifiers) {
        ResponseWrapper oktaResponse = this.performGetRequest(url.toString(), true, syncStatusFacade);
        if (!oktaResponse.isSuccess()) {
            syncStatusFacade.fail("This usually means that we were not able to connect to Okta or did not get a reply. Please check your network connection and make sure that Okta's endpoints are reachable. (see https://wiki.resolution.de/go/idpEndpoints) Error message: " + oktaResponse.getMessage(), oktaResponse.getCode(), oktaResponse.getMessage(), oktaResponse.getBody(), logger);
            return oktaResponse;
        }
        for (StructuredData currentUserAttributes : oktaResponse.getBodyAsStructuredData().asList()) {
            if (!syncStatusFacade.isRunning()) {
                return oktaResponse;
            }
            String userIdentifier = currentUserAttributes.findString(OKTA_ATTRIBUTE_ID_EXPRESSION);
            if (userIdentifier == null) {
                syncStatusFacade.failPartially("userIdentifier is null, that's unexpected here.", logger);
                continue;
            }
            if (seenUserIdentifiers.contains(userIdentifier)) {
                logger.debug("Skipping already synced user {}", (Object)userIdentifier);
                continue;
            }
            seenUserIdentifiers.add(userIdentifier);
            if (STATUS_DEPROVISIONED.equals(currentUserAttributes.findString(STATUS_EXPRESSION))) continue;
            try {
                currentUserAttributes.put((Object)"GROUPS", this.fetchGroupsForUser(userIdentifier, syncStatusFacade).stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.toList()));
                syncFunction.accept(currentUserAttributes.asMap());
            }
            catch (HTTPRequestFailedException e) {
                syncStatusFacade.failPartially("Could not retrieve groups. This is usually caused by networking issues when connecting to Okta.", (Exception)((Object)e), logger);
            }
        }
        return oktaResponse;
    }

    @Override
    protected void applyRateLimitRulesAndWait(@Nonnull ResponseWrapper response, int retryCount, int maxRetries, @Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        int rateLimitReset;
        int rateLimitRemaining;
        int rateLimitLimit;
        if (response.getCode() != 429 && ((OktaConnectorConfiguration)this.getConfiguration()).getRateLimitThreshold() <= 0) {
            syncStatusFacade.add("Rate limit handling disabled in connector configuration.", SyncStatusFacade.LogLevel.DEBUG, logger);
            return;
        }
        if (retryCount >= maxRetries) {
            throw new RequestFailedException("The request failed as it exceeded the maximum allowed number of retry attempts due to reaching the rate limit.");
        }
        try {
            rateLimitLimit = Integer.parseInt(Objects.requireNonNull(response.getHeader("X-Rate-Limit-Limit")));
            rateLimitRemaining = Integer.parseInt(Objects.requireNonNull(response.getHeader("X-Rate-Limit-Remaining")));
            rateLimitReset = Integer.parseInt(Objects.requireNonNull(response.getHeader("X-Rate-Limit-Reset")));
        }
        catch (NullPointerException | NumberFormatException e) {
            syncStatusFacade.add("Could not parse rate limit headers, ignoring rate limiting", e, SyncStatusFacade.LogLevel.ERROR, logger);
            return;
        }
        double rateLimitRatio = (1.0 - (double)rateLimitRemaining / (double)rateLimitLimit) * 100.0;
        logger.trace("X-Rate-Limit-Limit: {}, X-Rate-Limit-Remaining: {}, X-Rate-Limit-Reset: {}, Ratio: {}", new Object[]{rateLimitLimit, rateLimitRemaining, rateLimitReset, rateLimitRatio});
        if (response.getCode() != 429 && rateLimitRatio < (double)((OktaConnectorConfiguration)this.configuration).getRateLimitThreshold()) {
            logger.trace("Rate limit ratio is below configured rate limit threshold, continuing without delay.");
            return;
        }
        Instant rateLimitResetInstant = Instant.ofEpochSecond(rateLimitReset).plusMillis(RANDOM.nextInt(10000));
        syncStatusFacade.add("Rate limit threshold reached, sync will resume on " + String.valueOf(rateLimitResetInstant), null, SyncStatusFacade.LogLevel.INFO, logger);
        while (Instant.now().isBefore(rateLimitResetInstant)) {
            syncStatusFacade.checkCancelAndSendHeartbeat();
            long secondsRemaining = Duration.between(Instant.now(), rateLimitResetInstant).toMillis() / 1000L;
            logger.debug("Rate limit threshold reached, waiting for {} more seconds.", (Object)secondsRemaining);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                syncStatusFacade.add("Interrupted during sleep, cancelling sync", SyncStatusFacade.LogLevel.WARN, logger);
                Thread.currentThread().interrupt();
                syncStatusFacade.cancel();
                return;
            }
        }
    }

    @Nonnull
    public HttpUrl.Builder getUrlBase() {
        return new HttpUrl.Builder().scheme("https").host(((OktaConnectorConfiguration)this.getConfiguration()).getOktaDomain()).addPathSegment("api").addPathSegment("v1");
    }

    @Nonnull
    public HttpUrl.Builder getUsersUrlBase() {
        return this.getUrlBase().addPathSegment(PATH_SEGMENT_USERS);
    }

    @Nonnull
    public HttpUrl.Builder getGroupsUrlBase() {
        return this.getUrlBase().addPathSegment(PATH_SEGMENT_GROUPS);
    }

    @Nullable
    public static HttpUrl parseNextPageUrl(ResponseWrapper response) {
        for (String linkHeader : response.getHeaders("Link")) {
            Matcher m = HEADER_LINK_REGEX.matcher(linkHeader);
            if (!m.matches()) continue;
            return HttpUrl.parse((String)m.group(1));
        }
        return null;
    }

    @Nonnull
    public ResponseWrapper fetchGroupsPage(@Nullable HttpUrl fetchUrl, @Nonnull SyncStatusFacade syncStatusFacade) {
        HttpUrl url = fetchUrl == null ? this.getGroupsUrlBase().addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build() : fetchUrl;
        return this.performGetRequest(url.toString(), true, syncStatusFacade);
    }

    @Override
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull SyncStatusFacade syncStatusFacade) throws RequiredGroupCheckFailedException {
        return this.fetchRequiredConnectorGroups(requiredGroupCheckerHolder, syncStatusFacade, null);
    }

    @Nonnull
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull SyncStatusFacade syncStatusFacade, @Nullable Predicate<Set<ConnectorGroup>> stopCondition) throws RequiredGroupCheckFailedException {
        syncStatusFacade.add("Calculating required groups...", SyncStatusFacade.LogLevel.DEBUG, logger);
        RequiredConnectorGroupsIterator requiredConnectorGroupsIterator = new RequiredConnectorGroupsIterator(requiredGroupCheckerHolder, syncStatusFacade, stopCondition);
        HashSet<ConnectorGroup> requiredConnectorGroups = new HashSet<ConnectorGroup>();
        while (syncStatusFacade.isRunning() && requiredConnectorGroupsIterator.hasNext()) {
            requiredConnectorGroups.addAll((Collection<ConnectorGroup>)requiredConnectorGroupsIterator.next());
        }
        return requiredConnectorGroups;
    }

    @Nonnull
    public Set<ConnectorGroup> fetchGroupsForUser(@Nonnull String userIdentifier, @Nonnull SyncStatusFacade syncStatusFacade) throws HTTPRequestFailedException {
        ResponseWrapper groupResponse;
        HashSet<ConnectorGroup> groups = new HashSet<ConnectorGroup>();
        HttpUrl nextPageUrl = null;
        do {
            HttpUrl url;
            if (!(groupResponse = this.fetchGroupsPage(url = nextPageUrl == null ? this.getUsersUrlBase().addPathSegment(userIdentifier).addPathSegment(PATH_SEGMENT_GROUPS).addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build() : nextPageUrl, syncStatusFacade)).isSuccess()) {
                throw new HTTPRequestFailedException(groupResponse);
            }
            groups.addAll(this.parseGroupWithJackson(groupResponse));
        } while ((nextPageUrl = OktaConnector.parseNextPageUrl(groupResponse)) != null && syncStatusFacade.isRunning());
        return groups;
    }

    private Set<ConnectorGroup> parseGroupWithJackson(@Nonnull ResponseWrapper groupResponse) {
        HashSet<ConnectorGroup> connectorGroups = new HashSet<ConnectorGroup>();
        JsonNode groupData = groupResponse.getBodyAsJsonNode();
        if (groupData.isArray()) {
            for (JsonNode jsonGroup : groupData) {
                String id = jsonGroup.path("id").asText();
                String name = jsonGroup.path("profile").path("name").asText();
                if (id == null || id.isEmpty() || name == null || name.isEmpty()) continue;
                connectorGroups.add(new ConnectorGroup(id, name, ((OktaConnectorConfiguration)this.configuration).isUseRequiredConnectorGroupsGroovy() ? JSONUtil.asJson((Object)jsonGroup) : "{}"));
            }
        }
        return connectorGroups;
    }

    @Override
    @Nonnull
    public Class<OktaConnectorConfiguration> getConfigurationClass() {
        return OktaConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Okta";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return CONNECTOR_ATTRIBUTES;
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsGroovy() {
        return true;
    }

    @Override
    public boolean isCanFetchRequiredConnectorGroups() {
        return true;
    }

    @Override
    protected boolean reauthenticateConnector() {
        return false;
    }

    @Override
    @Nonnull
    protected String getAuthorizationHeaderValue() {
        return "SSWS " + ((OktaConnectorConfiguration)this.configuration).getApiToken();
    }

    @Override
    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        ArrayList<ConnectionTestResultEntity.EndpointResult> tests = new ArrayList<ConnectionTestResultEntity.EndpointResult>();
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        tests.add(this.runSpecificConnectionTest(this.getUsersUrlBase().addQueryParameter(PARAMETER_LIMIT, "1").build(), syncStatusFacade, "Fetch User"));
        tests.add(this.runSpecificConnectionTest(this.getGroupsUrlBase().addQueryParameter(PARAMETER_LIMIT, "1").build(), syncStatusFacade, "Fetch Group"));
        return tests;
    }

    private ConnectionTestResultEntity.EndpointResult runSpecificConnectionTest(@Nonnull HttpUrl url, @Nonnull SyncStatusFacade syncStatusFacade, @Nonnull String testName) {
        ResponseWrapper userResp = this.performGetRequest(url.toString(), false, false, syncStatusFacade);
        return ConnectionTestResultEntity.EndpointResult.create(testName, url.toString(), userResp.getCode() == 200, String.valueOf(userResp.getCode()), userResp.getBody());
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsServerFilter() {
        return true;
    }

    private class RequiredConnectorGroupsIterator
    implements Iterator<Collection<ConnectorGroup>> {
        @Nullable
        private final Predicate<Set<ConnectorGroup>> stopCondition;
        @Nonnull
        private final SyncStatusFacade syncStatusFacade;
        @Nonnull
        private final RequiredGroupCheckerHolder requiredGroupCheckerHolder;
        @Nullable
        private HttpUrl nextPageUrl;

        public RequiredConnectorGroupsIterator(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nullable SyncStatusFacade syncStatusFacade, Predicate<Set<ConnectorGroup>> stopCondition) {
            this.requiredGroupCheckerHolder = requiredGroupCheckerHolder;
            this.syncStatusFacade = syncStatusFacade;
            this.stopCondition = stopCondition;
            HttpUrl.Builder urlBuilder = OktaConnector.this.getGroupsUrlBase();
            Optional<ServerFilterBasedRequiredGroupChecker> serverFilterBasedRequiredGroupChecker = this.requiredGroupCheckerHolder.getServerFilterBasedRequiredGroupChecker();
            serverFilterBasedRequiredGroupChecker.ifPresent(filterBasedRequiredGroupChecker -> urlBuilder.addQueryParameter("search", filterBasedRequiredGroupChecker.getCustomServerFilter()));
            this.nextPageUrl = urlBuilder.build();
        }

        @Override
        public boolean hasNext() {
            return this.nextPageUrl != null;
        }

        @Override
        public Collection<ConnectorGroup> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ResponseWrapper responseWrapper = OktaConnector.this.fetchGroupsPage(this.nextPageUrl, this.syncStatusFacade);
            if (!responseWrapper.isSuccess()) {
                if (responseWrapper.getCode() == 401 || responseWrapper.getCode() == 403) {
                    throw new RequiredGroupCheckFailedException("Please check if the API token is valid.");
                }
                if (responseWrapper.getCode() == 400) {
                    String errorSummary = responseWrapper.getBodyAsStructuredData().findString(StructuredData.prepareFind((String)"errorSummary"));
                    String errorCauses = String.join((CharSequence)" ", responseWrapper.getBodyAsStructuredData().findOrEmpty(StructuredData.prepareFind((String)"errorCauses.collect{it.errorSummary}")).asStringList()).trim();
                    String reason = errorSummary != null ? errorSummary : "Okta returned status code 400 (Bad Request), but no reason was provided in the response.";
                    reason = StringUtil.isNullOrEmpty((String)errorCauses) ? reason : reason + " " + errorCauses;
                    throw new RequiredGroupCheckFailedException(reason);
                }
                throw new RequiredGroupCheckFailedException("Fetching groups failed. This usually means that we were not able to connect to Okta or did not get a reply. Please check your network connection and make sure that Okta's endpoints are reachable. (see https://wiki.resolution.de/go/idpEndpoints) Error message: " + responseWrapper.getMessage());
            }
            JsonNode groupData = responseWrapper.getBodyAsJsonNode();
            if (!groupData.isArray()) {
                this.syncStatusFacade.fail("Group response is no list", logger);
                logger.warn("Unexpected group-data {}", (Object)groupData);
                this.nextPageUrl = null;
                return Collections.emptySet();
            }
            Set<ConnectorGroup> connectorGroups = StreamSupport.stream(groupData.spliterator(), false).map(this::createConnectorGroup).filter(Objects::nonNull).filter(connectorGroup -> OktaConnector.matchesLocalRequiredGroupChecker(connectorGroup, this.requiredGroupCheckerHolder)).collect(Collectors.toSet());
            this.nextPageUrl = this.stopCondition != null && this.stopCondition.test(connectorGroups) ? null : OktaConnector.parseNextPageUrl(responseWrapper);
            return connectorGroups;
        }

        @Nullable
        private ConnectorGroup createConnectorGroup(@Nonnull JsonNode group) {
            String id = group.path("id").asText();
            String name = group.path("profile").path("name").asText();
            if (StringUtil.isNullOrEmpty((String)id)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invalid group, id is null or empty: {}", (Object)JSONUtil.asJson((Object)group));
                }
                return null;
            }
            return new ConnectorGroup(id, name, JSONUtil.asJson((Object)group));
        }
    }
}

