/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.groovyconnector;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.Utils;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnector;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorCode;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorConfiguration;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorConfigurationImpl;
import de.resolution.usersync.builtin.groovyconnector.GroovyScriptCompilationFailedException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import groovy.lang.GroovyClassLoader;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

@Named(value="groovyConnectorFactory")
public class GroovyConnectorFactory
extends AbstractConnectorFactory<GroovyConnector, GroovyConnectorConfiguration> {
    private static final String DEFAULT_SCRIPT = Utils.readFromClasspath("/GroovyConnectorDefault.groovy");
    private final ComponentLocator componentLocator;

    @Inject
    public GroovyConnectorFactory(ConnectorService connectorService, @ComponentImport ComponentLocator componentLocator, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.componentLocator = componentLocator;
    }

    @Override
    @Nonnull
    public GroovyConnector create(@Nonnull GroovyConnectorConfiguration connectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        try {
            GroovyConnectorCode groovyCode = this.compileGroovyCode(connectorConfiguration.getGroovyCode());
            return new GroovyConnector(this.connectorService, connectorConfiguration, groovyCode, this.componentLocator, this.atlasUserAdapter, true, System.currentTimeMillis());
        }
        catch (GroovyScriptCompilationFailedException e) {
            return new GroovyConnector(this.connectorService, connectorConfiguration, null, this.componentLocator, this.atlasUserAdapter, true, System.currentTimeMillis());
        }
    }

    @Override
    @Nonnull
    public Class<GroovyConnector> getConnectorClass() {
        return GroovyConnector.class;
    }

    @Override
    @Nonnull
    public Class<GroovyConnectorConfiguration> getConfigurationClass() {
        return GroovyConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Groovy";
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Connector containing a Groovy Script";
    }

    @Override
    @Nonnull
    public GroovyConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        GroovyConnectorConfigurationImpl config = new GroovyConnectorConfigurationImpl();
        config.setName("new Groovy Connector");
        config.setUniqueId(uniqueId);
        config.setGroovyCode(DEFAULT_SCRIPT);
        return config;
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull GroovyConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        ValidationResult codeResult = ValidationResult.create();
        validationResult.add("groovyCode", codeResult);
        if (config.getGroovyCode() == null || config.getGroovyCode().isEmpty()) {
            codeResult.addError("GroovyCode must not be empty");
        } else {
            try {
                GroovyConnectorCode compiledCode = this.compileGroovyCode(config.getGroovyCode());
                if (this.usesDeprecatedSyncSingleUser(compiledCode)) {
                    codeResult.addWarning("The code should override syncSingleUser(SyncSingleUserWrapper) instead of syncSingleUser(String,Map,Map)");
                }
            }
            catch (GroovyScriptCompilationFailedException e) {
                codeResult.addError(e.getMessage());
            }
        }
        return validationResult;
    }

    private boolean usesDeprecatedSyncSingleUser(GroovyConnectorCode compiledCode) {
        try {
            compiledCode.getClass().getDeclaredMethod("syncSingleUser", String.class, Map.class, Map.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public GroovyConnectorCode compileGroovyCode(String groovyCode) throws GroovyScriptCompilationFailedException {
        GroovyConnectorCode groovyConnectorCode;
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStarImports(new String[]{"de.resolution.usersync.builtin.groovyconnector", "de.resolution.usersync.api", "de.resolution.usersync.api.exception", "de.resolution.usersync.spi", "de.resolution.usersync.util", "de.resolution.usersync.util.http", "de.resolution.atlasuser.api.user", "de.resolution.atlasuser.api.directory", "de.resolution.atlasuser.api.exception", "de.resolution.atlasuser.api", "de.resolution.atlasuser.impl.user", "de.resolution.retransform.data", "jakarta.annotation", "groovy.json", "okhttp3"});
        importCustomizer.addStaticStars(new String[]{"de.resolution.usersync.api.FindUserResult"});
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader(), compilerConfig);
        try {
            Class scriptClass = groovyClassLoader.parseClass(groovyCode);
            groovyConnectorCode = (GroovyConnectorCode)scriptClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    groovyClassLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CompilationFailedException e) {
                throw new GroovyScriptCompilationFailedException(e);
            }
        }
        groovyClassLoader.close();
        return groovyConnectorCode;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editGroovyConnector.json";
    }
}

