/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.groovyconnector;

import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.exception.NotImplementedException;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnector;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorFailedException;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorUtils;
import de.resolution.usersync.builtin.groovyconnector.SyncSingleUserWrapper;
import de.resolution.usersync.builtin.groovyconnector.SyncWrapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroovyConnectorCode {
    protected static final Logger logger = LoggerFactory.getLogger(GroovyConnectorCode.class);
    protected GroovyConnector connector;
    protected HTTPWrapper http = new HTTPWrapper();
    protected ComponentLocator componentLocator;
    protected AtlasUserAdapter atlasUserAdapter;
    protected ConnectorService connectorService;

    protected void init() {
    }

    public void sync(SyncWrapper sync) {
        sync.fail("Sync is not implemented");
    }

    public FindUserResult findUser(String identifier) {
        return FindUserResult.failed(new NotImplementedException("Single User Sync is not implemented"));
    }

    public FindUserResult findUser(SyncSingleUserWrapper syncSingleUserWrapper) {
        return FindUserResult.failed(new NotImplementedException("findUser(SyncSingleUserWrapper syncSingleUserWrapper) is not implemented"));
    }

    public SyncSingleUserResult syncSingleUser(SyncSingleUserWrapper syncSingleUserWrapper) {
        return this.connector.syncSingleUserInParent(syncSingleUserWrapper.getIdentifier(), syncSingleUserWrapper.getAdditionalData(), syncSingleUserWrapper.getAttributesToOverride(), syncSingleUserWrapper.getOverridingPrimaryAttribute());
    }

    @Nonnull
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable Map<?, ?> additionalData, @Nullable Map<String, Set<String>> attributesToOverride) throws GroovyConnectorFailedException {
        this.fail("syncSingleUser() with the old method signature should never be called from the GroovyConnectorCode-class");
        return null;
    }

    protected FindUserResult found(Map<Object, Object> attributes) {
        Map<String, List<String>> attributeMap = GroovyConnectorUtils.convertAllToString(attributes);
        if (attributeMap != null) {
            return FindUserResult.found((StructuredData)StructuredData.create(attributeMap));
        }
        return FindUserResult.notFound();
    }

    protected FindUserResult failed(Exception e) {
        return FindUserResult.failed(e);
    }

    protected FindUserResult failed(Object obj) {
        return FindUserResult.failed(obj.toString());
    }

    @Nullable
    protected String read(String key) {
        return this.connector.getConnectorStorageValue(key).orElse(null);
    }

    protected void write(String key, Object value) {
        this.connector.setConnectorStorageValue(key, value.toString());
    }

    protected Map<String, String> readAll() {
        return this.connector.getAllConnectorStorageValues();
    }

    protected void debug(Object obj) {
        if (logger.isDebugEnabled()) {
            logger.debug(obj.toString());
        }
    }

    protected void info(Object obj) {
        if (logger.isInfoEnabled()) {
            logger.info(obj.toString());
        }
    }

    protected void warn(Object obj) {
        if (logger.isWarnEnabled()) {
            logger.warn(obj.toString());
        }
    }

    protected String asJson(Object obj) {
        return JSONUtil.asJson((Object)obj);
    }

    protected void fail(Object message) throws GroovyConnectorFailedException {
        throw new GroovyConnectorFailedException(message.toString());
    }
}

