/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.excel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.ConnectorStorageManager;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.excel.ExcelImporterConnector;
import de.resolution.usersync.builtin.excel.ExcelImporterConnectorConfiguration;
import de.resolution.usersync.builtin.excel.ExcelImporterConnectorConfigurationImpl;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.stereotype.Component;

@Component
@JsonAutoDetect
public class ExcelImporterConnectorFactory
extends AbstractConnectorFactory<ExcelImporterConnector, ExcelImporterConnectorConfiguration> {
    private static final String NAME = "Import Users from Excel";
    private static final String DESCRIPTION = "Imports users from an Excel-Workbook";
    private final ConnectorStorageManager connectorStorageManager;

    @Inject
    public ExcelImporterConnectorFactory(ConnectorService connectorService, ConnectorStorageManager connectorStorageManager, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.connectorStorageManager = connectorStorageManager;
    }

    @Override
    @Nonnull
    public ExcelImporterConnector create(@Nonnull ExcelImporterConnectorConfiguration excelImporterConnectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new ExcelImporterConnector(excelImporterConnectorConfiguration, this.connectorService, this.atlasUserAdapter, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public ExcelImporterConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        ExcelImporterConnectorConfigurationImpl mutableConfig = new ExcelImporterConnectorConfigurationImpl();
        mutableConfig.setName("new Excel Import");
        mutableConfig.setUniqueId(uniqueId);
        mutableConfig.setDirectoryId(this.connectorService.getFirstWritableDirectoryId());
        return mutableConfig;
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull ExcelImporterConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        String filename = this.connectorStorageManager.get(config.getUniqueId(), "excelFile").orElse(null);
        if (filename == null) {
            validationResult.add("excelFile", "No Excel-file present");
        } else {
            Path path = Paths.get(filename, new String[0]);
            if (!Files.isReadable(path)) {
                validationResult.add("ExcelFile", "File " + filename + " is not readable");
            }
        }
        return validationResult;
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    @Nonnull
    public Class<ExcelImporterConnector> getConnectorClass() {
        return ExcelImporterConnector.class;
    }

    @Override
    @Nonnull
    public Class<ExcelImporterConnectorConfiguration> getConfigurationClass() {
        return ExcelImporterConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editExcelImporterConnector.json";
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

