/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.excel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SharedHomeProvider;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.excel.ExcelExporterConnector;
import de.resolution.usersync.builtin.excel.ExcelExporterConnectorConfiguration;
import de.resolution.usersync.builtin.excel.ExcelExporterConnectorConfigurationImpl;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@JsonAutoDetect
public class ExcelExporterConnectorFactory
extends AbstractConnectorFactory<ExcelExporterConnector, ExcelExporterConnectorConfiguration> {
    private static final String NAME = "Export Users to Excel";
    private static final String DESCRIPTION = "Exports users to an Excel-Workbook";
    private final SharedHomeProvider sharedHomeProvider;

    @Inject
    public ExcelExporterConnectorFactory(ConnectorService connectorService, SharedHomeProvider sharedHomeProvider, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.sharedHomeProvider = sharedHomeProvider;
    }

    @Override
    @Nonnull
    public ExcelExporterConnector create(@Nonnull ExcelExporterConnectorConfiguration excelExporterConnectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new ExcelExporterConnector(excelExporterConnectorConfiguration, this.connectorService, this.atlasUserAdapter, newConnector, lastUpdated, this.sharedHomeProvider.getSharedHome());
    }

    @Override
    @Nonnull
    public ExcelExporterConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        ExcelExporterConnectorConfigurationImpl mutableConfig = new ExcelExporterConnectorConfigurationImpl();
        mutableConfig.setName("new Excel export");
        mutableConfig.setUniqueId(uniqueId);
        mutableConfig.setDirectoryId(this.connectorService.getFirstWritableDirectoryId());
        return mutableConfig;
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull ExcelExporterConnectorConfiguration config) {
        return super.validate(config);
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    @Nonnull
    public Class<ExcelExporterConnector> getConnectorClass() {
        return ExcelExporterConnector.class;
    }

    @Override
    @Nonnull
    public Class<ExcelExporterConnectorConfiguration> getConfigurationClass() {
        return ExcelExporterConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editExcelExporterConnector.json";
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

