/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.excel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.builtin.excel.ExcelExporterConnector;
import de.resolution.usersync.builtin.excel.ExcelExporterConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExcelExporterConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements ExcelExporterConnectorConfiguration {
    private boolean exportAsCsv = false;
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();

    public ExcelExporterConnectorConfigurationImpl() {
    }

    public ExcelExporterConnectorConfigurationImpl(ExcelExporterConnectorConfiguration other) {
        super(other);
        this.setExportAsCsv(other.isExportAsCsv());
    }

    @Override
    public boolean isExportAsCsv() {
        return this.exportAsCsv;
    }

    public void setExportAsCsv(boolean exportAsCsv) {
        this.exportAsCsv = exportAsCsv;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return "ATTR_NAME";
    }

    @Override
    @Nonnull
    public ExcelExporterConnectorConfigurationImpl sanitize() {
        return new ExcelExporterConnectorConfigurationImpl(this);
    }

    @Override
    @Nonnull
    public CleanupBehaviour getCleanupBehaviour() {
        return CleanupBehaviour.NONE;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return ExcelExporterConnector.class;
    }
}

