/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.usersync.builtin.azure.AzureConnectorConfiguration;
import de.resolution.usersync.builtin.azure.AzureGroup;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AzureGroupResult {
    @Nullable
    private final String nextPageUrl;
    @Nonnull
    private final List<AzureGroup> groups;

    @JsonCreator
    AzureGroupResult(@JsonProperty(value="@odata.nextLink") @Nullable String nextPageUrl, @JsonProperty(value="value") List<AzureGroup> groups) {
        this.nextPageUrl = nextPageUrl;
        this.groups = groups != null ? groups : new ArrayList();
    }

    @Nullable
    String getNextPageUrl() {
        return this.nextPageUrl;
    }

    @Nonnull
    public List<AzureGroup> getValidGroups(AzureConnectorConfiguration configuration) {
        return this.groups.stream().filter(AzureGroup::isValid).filter(group -> group.isGroupAllowed(configuration)).collect(Collectors.toList());
    }

    public List<AzureGroup> getGroups() {
        return this.groups;
    }
}

