/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.builtin.azure.AzureConnectorConfiguration;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class AzureGroup {
    private static final Logger logger = LoggerFactory.getLogger(AzureGroup.class);
    @JsonProperty
    private String id;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private List<String> groupTypes;
    @JsonProperty
    private boolean securityEnabled;
    @JsonProperty
    private boolean mailEnabled;
    @JsonProperty(value="@odata.type")
    private String oDataType;
    @JsonAnyGetter
    @JsonAnySetter
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isMailEnabled() {
        return this.mailEnabled;
    }

    public boolean isUnified() {
        return this.groupTypes != null && this.groupTypes.contains("Unified");
    }

    public AzureGroupType getGroupType() {
        if (!this.isUnified() && !this.mailEnabled && this.securityEnabled) {
            return AzureGroupType.SECURITY_GROUP;
        }
        if (!this.isUnified() && this.mailEnabled && this.securityEnabled) {
            return AzureGroupType.MAIL_ENABLED_SECURITY_GROUP;
        }
        if (this.isUnified() && this.mailEnabled && this.securityEnabled) {
            return AzureGroupType.OFFICE_365_GROUP_SECURITY_ENABLED;
        }
        if (this.isUnified() && this.mailEnabled && !this.securityEnabled) {
            return AzureGroupType.OFFICE_365_GROUP_NON_SECURITY_ENABLED;
        }
        if (!this.isUnified() && this.mailEnabled && !this.securityEnabled) {
            return AzureGroupType.DISTRIBUTION_GROUP;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Properties of group '{}': groupTypeUnified: {}, mailEnabled: {}, securityEnabled: {}", new Object[]{this.displayName, this.isUnified(), this.mailEnabled, this.securityEnabled});
        }
        return AzureGroupType.OTHER;
    }

    boolean isValid() {
        boolean isValid;
        boolean bl = isValid = !StringUtil.isNullOrEmpty((String)this.id) && !StringUtil.isNullOrEmpty((String)this.displayName) && (this.oDataType == null || Objects.equals("#microsoft.graph.group", this.oDataType));
        if (!isValid && logger.isDebugEnabled()) {
            logger.debug("Group with unexpected format: {}", (Object)JSONUtil.asJson((Object)this));
        }
        return isValid;
    }

    boolean isGroupAllowed(@Nonnull AzureConnectorConfiguration configuration) {
        AzureGroupType groupType = this.getGroupType();
        if (groupType == AzureGroupType.SECURITY_GROUP && configuration.isFetchSecurityGroups()) {
            return true;
        }
        if (groupType == AzureGroupType.MAIL_ENABLED_SECURITY_GROUP && configuration.isFetchMailEnabledSecurityGroups()) {
            return true;
        }
        if (groupType == AzureGroupType.DISTRIBUTION_GROUP && configuration.isFetchDistributionGroups()) {
            return true;
        }
        if (groupType == AzureGroupType.OFFICE_365_GROUP_SECURITY_ENABLED && configuration.isFetchOffice365GroupsSecurityEnabled()) {
            return true;
        }
        if (groupType == AzureGroupType.OFFICE_365_GROUP_NON_SECURITY_ENABLED && configuration.isFetchOffice365GroupsNonSecurityEnabled()) {
            return true;
        }
        logger.debug("Skipping group {} because fetching of groups of type {} is not allowed.", (Object)this.displayName, (Object)groupType);
        return false;
    }

    public ConnectorGroup asConnectorGroup() {
        return new ConnectorGroup(this.id, this.displayName, JSONUtil.asJson((Object)this));
    }

    static enum AzureGroupType {
        SECURITY_GROUP,
        MAIL_ENABLED_SECURITY_GROUP,
        DISTRIBUTION_GROUP,
        OFFICE_365_GROUP_SECURITY_ENABLED,
        OFFICE_365_GROUP_NON_SECURITY_ENABLED,
        OTHER;

    }
}

