/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.auditlog;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import de.resolution.commons.util.DiffUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.auditlog.AuditLogUtil;
import de.resolution.usersync.auditlog.UserSyncAuditLogService;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.spi.Connector;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewApiUserSyncAuditLogService
implements UserSyncAuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(NewApiUserSyncAuditLogService.class);
    private final AuditService auditService;
    private final Collection<String> pathsToIgnore = Collections.emptyList();
    private final Collection<String> pathToRedact = Arrays.asList("/clientSecret", "/apiToken");
    private static final String UID_TEXT = "Connector Unique ID";
    private static final String NAME_TEXT = "Connector Name";
    private static final String SYNC_STATUS_ID_TEXT = "Sync Status ID";
    private static final String CATEGORY = "User Sync";
    private static final String TYPE = "Connector";

    public NewApiUserSyncAuditLogService(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void connectorUpdated(String connectorId, String oldConfiguration, String newConfiguration) {
        List<DiffUtil.Change> changes;
        try {
            changes = DiffUtil.diff((String)oldConfiguration, (String)newConfiguration);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to calculate diff", (Throwable)e);
                logger.warn("Old: {}", (Object)JSONUtil.asJson((Object)oldConfiguration));
                logger.warn("New: {}", (Object)JSONUtil.asJson((Object)newConfiguration));
            }
            changes = Collections.singletonList(new DiffUtil.Change("", "Calculating diff failed: " + e.getMessage(), null));
        }
        List<ChangedValue> changedValues = AuditLogUtil.toChangedValues(changes, this.pathsToIgnore, this.pathToRedact);
        if (changedValues.isEmpty()) {
            logger.debug("Connector {} is not changed", (Object)connectorId);
            return;
        }
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)CATEGORY, (String)"Connector updated").build();
        AuditResource affectedObject = AuditResource.builder((String)connectorId, (String)TYPE).build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).changedValues(changedValues).build();
        this.auditService.audit(event);
    }

    @Override
    public void connectorCreated(@Nonnull Connector<?> connector) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)CATEGORY, (String)"Connector created").build();
        AuditResource affectedObject = AuditResource.builder((String)connector.getUniqueId(), (String)TYPE).build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).build();
        this.auditService.audit(event);
    }

    @Override
    public void connectorRemoved(@Nonnull String uniqueId) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)CATEGORY, (String)"Connector removed").build();
        AuditResource affectedObject = AuditResource.builder((String)uniqueId, (String)TYPE).build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).build();
        this.auditService.audit(event);
    }

    private void createSyncEvent(@Nonnull String title, @Nonnull SyncStatus syncStatus, @Nonnull ConnectorService connectorService) {
        Object connector;
        try {
            connector = connectorService.getConnectorByUniqueId(syncStatus.getConnectorUID()).getConnector();
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotFoundException e) {
            logger.warn("Failed to load connector", (Throwable)e);
            return;
        }
        String prefix = syncStatus.isScheduled() ? "Scheduled " : "Manual ";
        String fullTitle = prefix + title;
        AuditResource affectedObject = AuditResource.builder((String)connector.getName(), (String)TYPE).build();
        AuditAttribute nameAttr = AuditAttribute.fromI18nKeys((String)NAME_TEXT, (String)connector.getName()).build();
        AuditAttribute uidAttr = AuditAttribute.fromI18nKeys((String)UID_TEXT, (String)connector.getUniqueId()).build();
        AuditAttribute syncStatusIdAttr = AuditAttribute.fromI18nKeys((String)SYNC_STATUS_ID_TEXT, (String)String.valueOf(syncStatus.getId())).build();
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)CATEGORY, (String)fullTitle).build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).extraAttribute(nameAttr).extraAttribute(uidAttr).extraAttribute(syncStatusIdAttr).build();
        this.auditService.audit(event);
    }

    @Override
    public void syncStarted(@Nonnull SyncStatus syncStatus, @Nonnull ConnectorService connectorService) {
        this.createSyncEvent("Sync Started", syncStatus, connectorService);
    }

    @Override
    public void syncEnded(@Nonnull SyncStatus syncStatus, @Nonnull ConnectorService connectorService) {
        this.createSyncEvent("Sync Ended", syncStatus, connectorService);
    }

    @Override
    public void syncCanceled(@Nonnull SyncStatus syncStatus, @Nonnull ConnectorService connectorService) {
        this.createSyncEvent("Sync Canceled", syncStatus, connectorService);
    }
}

