/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.cleanup;

import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.commons.util.PasswordUtil;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.CleanupFunction;
import de.resolution.usersync.util.UserSyncUtils;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UserCleanup {
    protected final CleanupBehaviour behaviour;
    protected final AtlasUserAdapter atlasUserAdapter;
    protected final Collection<String> knownAttributes;
    protected final boolean removeAllGroupAssignmentsOnCleanup;
    protected final Set<String> groupsOrRegexNotBeRemoved;

    public UserCleanup(CleanupBehaviour behaviour, AtlasUserAdapter atlasUserAdapter, Collection<String> knownAttributes, boolean removeAllGroupAssignmentsOnCleanup, List<String> groupsOrRegexNotBeRemoved) {
        this.behaviour = behaviour;
        this.atlasUserAdapter = atlasUserAdapter;
        this.knownAttributes = knownAttributes;
        this.removeAllGroupAssignmentsOnCleanup = removeAllGroupAssignmentsOnCleanup;
        this.groupsOrRegexNotBeRemoved = new HashSet<String>(groupsOrRegexNotBeRemoved);
    }

    protected AtlasUserResult cleanupUser(AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder, long timestamp, boolean simulate) {
        return switch (this.behaviour) {
            case CleanupBehaviour.DELETE -> this.atlasUserAdapter.delete(atlasUser.getReference(), simulate);
            case CleanupBehaviour.DISABLE -> {
                if (this.removeAllGroupAssignmentsOnCleanup) {
                    yield this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(false).with("ATTR_GROUPS", this.getGroupsToRemain(atlasUser)).build(), timestamp, null, simulate);
                }
                if (atlasUser.isActive()) {
                    yield this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(false).build(), timestamp, null, simulate);
                }
                yield resultBuilder.operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            }
            case CleanupBehaviour.ANONYMIZE_REVERSIBLE -> {
                if (!atlasUser.get("ATTR_IS_ANONYMIZED").isPresent()) {
                    String randomString;
                    while (this.userWithUsernameExistsInAnyDirectory(randomString = "user-" + PasswordUtil.generateSecureRandomToken((int)5, (int)0, (int)5))) {
                    }
                    AtlasUserBuilder builder = AtlasUser.builder().findBy(atlasUser.getReference()).active(false).with("ATTR_NAME", new Object[]{randomString}).with("ATTR_EMAIL", new Object[]{randomString + "@anon.user"}).with("ATTR_FULLNAME", new Object[]{randomString}).with("ATTR_IS_ANONYMIZED", true);
                    if (this.removeAllGroupAssignmentsOnCleanup) {
                        builder.with("ATTR_GROUPS", this.getGroupsToRemain(atlasUser));
                    }
                    yield this.atlasUserAdapter.update(builder.build(), this.knownAttributes, simulate);
                }
                if (this.removeAllGroupAssignmentsOnCleanup) {
                    yield this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(false).with("ATTR_GROUPS", this.getGroupsToRemain(atlasUser)).build(), this.knownAttributes, simulate);
                }
                yield resultBuilder.operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            }
            case CleanupBehaviour.NONE -> {
                if (this.removeAllGroupAssignmentsOnCleanup) {
                    yield this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(atlasUser.isActive()).with("ATTR_GROUPS", this.getGroupsToRemain(atlasUser)).build(), this.knownAttributes, simulate);
                }
                yield resultBuilder.operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            }
            default -> throw new CleanupFunction.UnexpectedBehaviourException(this.behaviour);
        };
    }

    @Nonnull
    protected Set<String> getGroupsToRemain(@Nonnull AtlasUser atlasUser) {
        Set<String> groupsToRemain = Collections.emptySet();
        if (!this.groupsOrRegexNotBeRemoved.isEmpty()) {
            groupsToRemain = atlasUser.getAttributeValues("ATTR_GROUPS").stream().filter(this::isGroupExcludedFromRemoval).collect(Collectors.toSet());
        }
        return groupsToRemain;
    }

    protected boolean isGroupExcludedFromRemoval(@Nonnull String grp) {
        return this.groupsOrRegexNotBeRemoved.stream().anyMatch(regex -> Pattern.compile(regex).matcher(grp).matches());
    }

    protected boolean userWithUsernameExistsInAnyDirectory(String username) {
        AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_NAME", (Object)username, (long)-3L), this.knownAttributes);
        return UserSyncUtils.checkSuccess(readResult);
    }

    public AtlasUserResult cleanupUser(AtlasUser atlasUser, boolean simulate) {
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).initialUser(atlasUser);
        return this.cleanupUser(atlasUser, resultBuilder, System.currentTimeMillis(), simulate);
    }

    protected boolean userIsAlreadyCleanedUp(AtlasUser atlasUser) {
        switch (this.behaviour) {
            case DISABLE: {
                return !atlasUser.isActive();
            }
            case ANONYMIZE_REVERSIBLE: {
                return !this.removeAllGroupAssignmentsOnCleanup && atlasUser.get("ATTR_IS_ANONYMIZED").isPresent();
            }
            case NONE: {
                return !this.removeAllGroupAssignmentsOnCleanup;
            }
        }
        return false;
    }
}

