/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.cleanup;

import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.cleanup.CleanupDecider;
import de.resolution.usersync.api.cleanup.CleanupDecisionException;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyCleanupDecider
implements CleanupDecider {
    public static final String DEFAULT_CODE = "boolean shouldCleanup(AtlasUser atlasUser, long syncStartedAtTimestamp) {\n    return timestamp(atlasUser) < syncStartedAtTimestamp\n}";
    private final Class<GroovyCleanupDeciderScript> cleanupDeciderScriptClass;

    public GroovyCleanupDecider(@Nullable String groovyCode) throws GroovyScriptException {
        if (groovyCode == null) {
            throw new GroovyScriptException("Code must not be null");
        }
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStarImports(new String[]{"de.resolution.commons.data", "javax.annotation", "de.resolution.atlasuser.api.user"});
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        compilerConfig.setScriptBaseClass("de.resolution.usersync.api.cleanup.GroovyCleanupDecider$GroovyCleanupDeciderScript");
        try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader(GroovyCleanupDeciderScript.class.getClassLoader(), compilerConfig);){
            this.cleanupDeciderScriptClass = groovyClassLoader.parseClass(groovyCode);
        }
        catch (IOException | ClassCastException | CompilationFailedException e) {
            throw new GroovyScriptException(e);
        }
    }

    @Override
    public boolean shouldCleanup(@Nonnull AtlasUser atlasUser, long syncStartedAtTimestamp) throws GroovyScriptException {
        try {
            GroovyCleanupDeciderScript groovyCleanupDeciderScript = this.cleanupDeciderScriptClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return groovyCleanupDeciderScript.shouldCleanup(atlasUser, syncStartedAtTimestamp);
        }
        catch (Exception e) {
            throw new GroovyScriptException(e);
        }
    }

    public static class GroovyScriptException
    extends CleanupDecisionException {
        public GroovyScriptException(Throwable cause) {
            super(cause);
        }

        public GroovyScriptException(String message) {
            super(message);
        }
    }

    public static abstract class GroovyCleanupDeciderScript
    extends Script
    implements CleanupDecider {
        protected final Logger logger = LoggerFactory.getLogger(GroovyCleanupDeciderScript.class);

        protected long now() {
            return System.currentTimeMillis();
        }

        @Nullable
        protected String get(@Nonnull AtlasUser atlasUser, @Nonnull String key) {
            return atlasUser.get(key).orElse(null);
        }

        protected String asJson(Object object) {
            return JSONUtil.asJson((Object)object);
        }

        protected long timestamp(@Nonnull AtlasUser atlasUser) {
            long realTimestamp = Long.parseLong(atlasUser.get("ATLAS_USER_TIMESTAMP").orElse("0"));
            long simulateTimestamp = Long.parseLong(atlasUser.get("ATLAS_USER_SIMULATE_TIMESTAMP").orElse("0"));
            return Math.max(simulateTimestamp, realTimestamp);
        }
    }
}

