/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.usersync.impl.NotificationImpl;
import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.UUID;

public interface Notification {
    public static final String ID_PREFIX_CONNECTOR = "CON";
    public static final NotificationComparator COMPARATOR = new NotificationComparator();

    public static Notification createForConnector(@Nonnull String message, @Nonnull Level level, @Nonnull String msgId, String connectorUID) {
        return new NotificationImpl(message, level, msgId, ID_PREFIX_CONNECTOR + connectorUID);
    }

    public static Notification createForConnector(@Nonnull String message, @Nonnull Level level, String connectorUID) {
        return new NotificationImpl(message, level, Notification.generateMessageId(), ID_PREFIX_CONNECTOR + connectorUID);
    }

    public static String generateMessageId() {
        return UUID.randomUUID().toString();
    }

    public String getMessage();

    public Level getLevel();

    public String getMessageId();

    public String getContextId();

    public long getCreatedAt();

    default public String getAppearance() {
        switch (this.getLevel().ordinal()) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "error";
            }
        }
        return "info";
    }

    public static enum Level {
        INFO,
        WARNING,
        ERROR;

    }

    public static class NotificationComparator
    implements Comparator<Notification> {
        @Override
        public int compare(Notification o1, Notification o2) {
            return Long.compare(o2.getCreatedAt(), o1.getCreatedAt());
        }
    }
}

