/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.systeminformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.reconfigure.api.SystemInformationApplication;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@JsonAutoDetect
public class SystemInformationApplicationImpl
implements SystemInformationApplication {
    private static final Pattern JAVA_AGENT_PATTERN = Pattern.compile("-javaagent:");
    private static final Pattern APP_DYNAMICS_AGENT_PATTERN = Pattern.compile("-javaagent:.*javaagent\\.jar");
    private final String dbName;
    private final String dbVersion;
    private final String dbDescriptorValue;
    private final String appServer;
    private final String databaseType;
    private final String dbDescriptorLabel;
    private final String installationType;
    private final Boolean mayUseAppDynamicsAgent;
    private final Boolean usesJavaAgent;
    private final String dbCollation;
    private final String dbProductVersion;
    private final String dbDriverName;
    private final String dbDriverVersion;
    private final String dbURL;
    private final Boolean clustering;
    private final String clusterNodeId;
    private final Set<String> clusterNodes;

    public SystemInformationApplicationImpl(@Nonnull Map<String, String> systemInfos, Set<String> nodes) {
        this.dbName = systemInfos.getOrDefault("dbName", null);
        this.dbVersion = systemInfos.getOrDefault("dbVersion", null);
        this.dbDescriptorValue = systemInfos.getOrDefault("dbDescriptorValue", null);
        this.appServer = systemInfos.getOrDefault("appServer", null);
        this.databaseType = systemInfos.getOrDefault("databaseType", null);
        this.dbDescriptorLabel = systemInfos.getOrDefault("dbDescriptorLabel", null);
        this.installationType = systemInfos.getOrDefault("installationType", null);
        String jvmInputArguments = systemInfos.getOrDefault("jvmInputArguments", null);
        if (jvmInputArguments != null) {
            this.usesJavaAgent = JAVA_AGENT_PATTERN.matcher(jvmInputArguments).find();
            this.mayUseAppDynamicsAgent = APP_DYNAMICS_AGENT_PATTERN.matcher(jvmInputArguments).find();
        } else {
            this.mayUseAppDynamicsAgent = null;
            this.usesJavaAgent = null;
        }
        this.dbCollation = systemInfos.getOrDefault("dbCollation", null);
        this.dbProductVersion = systemInfos.getOrDefault("dbProductVersion", null);
        this.dbDriverName = systemInfos.getOrDefault("dbDriverName", null);
        this.dbDriverVersion = systemInfos.getOrDefault("dbDriverVersion", null);
        this.dbURL = systemInfos.getOrDefault("dbURL", null);
        this.clustering = systemInfos.getOrDefault("clustering", "false").equals("true");
        this.clusterNodeId = systemInfos.getOrDefault("clusterNodeId", null);
        this.clusterNodes = nodes;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public String getDbVersion() {
        return this.dbVersion;
    }

    @Override
    public String getDbDescriptorValue() {
        return this.dbDescriptorValue;
    }

    @Override
    public String getAppServer() {
        return this.appServer;
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getDbDescriptorLabel() {
        return this.dbDescriptorLabel;
    }

    @Override
    public String getInstallationType() {
        return this.installationType;
    }

    @Override
    public Boolean getMayUseAppDynamicsAgent() {
        return this.mayUseAppDynamicsAgent;
    }

    @Override
    public Boolean getUsesJavaAgent() {
        return this.usesJavaAgent;
    }

    @Override
    public Boolean getClustering() {
        return this.clustering;
    }

    @Override
    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    @Override
    public Set<String> getClusterNodes() {
        return this.clusterNodes;
    }

    @Override
    public String getDbCollation() {
        return this.dbCollation;
    }

    @Override
    public String getDbProductVersion() {
        return this.dbProductVersion;
    }

    @Override
    public String getDbDriverName() {
        return this.dbDriverName;
    }

    @Override
    public String getDbDriverVersion() {
        return this.dbDriverVersion;
    }

    @Override
    public String getDbURL() {
        return this.dbURL;
    }
}

