/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.systeminformation;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.reconfigure.api.SystemInformation;
import de.resolution.reconfigure.api.SystemInformationProvider;
import de.resolution.reconfigure.systeminformation.SystemInformationImpl;
import de.resolution.reconfigure.systeminformation.TomcatConnectionInformation;
import de.resolution.reconfigure.systeminformation.TomcatServerInformation;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@ConfluenceComponent
@BitbucketComponent
@BambooComponent
@FecruComponent
public class DefaultSystemInformationProvider
implements SystemInformationProvider {
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private static final String TOMCAT_EMBED_DOMAIN = "Tomcat";
    private static final String TOMCAT_DOMAIN = "Catalina";
    private static final Logger logger = LoggerFactory.getLogger(DefaultSystemInformationProvider.class);

    @Inject
    public DefaultSystemInformationProvider(@ComponentImport PluginMetadataManager pluginMetadataManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.pluginMetadataManager = pluginMetadataManager;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public SystemInformation getSystemInformation() {
        HashSet plugins = new HashSet();
        this.pluginAccessor.getPlugins().forEach(plugin -> {
            if (this.pluginMetadataManager.isUserInstalled(plugin)) {
                plugins.add("Name: " + plugin.getName() + ", State: " + plugin.getPluginState().name() + ", Key: " + plugin.getKey() + ", Vendor: " + plugin.getPluginInformation().getVendorName());
            }
        });
        TomcatServerInformation tomcatServerInfo = null;
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (!mBeanServers.isEmpty()) {
            MBeanServer mBeanServer = (MBeanServer)mBeanServers.get(0);
            String domain = this.getTomcatDomain(mBeanServer);
            try {
                ObjectName server = new ObjectName(domain, "type", "Server");
                String shutdown = "";
                if (mBeanServer.getAttribute(server, "shutdown") != null) {
                    shutdown = mBeanServer.getAttribute(server, "shutdown").toString();
                }
                String serverPort = "";
                if (mBeanServer.getAttribute(server, "port") != null) {
                    serverPort = mBeanServer.getAttribute(server, "port").toString();
                }
                ObjectName service = new ObjectName(domain, "type", "Service");
                String serviceName = "";
                if (mBeanServer.getAttribute(service, "name") != null) {
                    serviceName = mBeanServer.getAttribute(service, "name").toString();
                }
                ObjectName[] objNames = (ObjectName[])mBeanServer.getAttribute(service, "connectorNames");
                HashSet<TomcatConnectionInformation> tomcatConnectionInfo = new HashSet<TomcatConnectionInformation>();
                for (ObjectName on : objNames) {
                    HashMap<String, String> attributeMap = new HashMap<String, String>();
                    List<String> attributes = Arrays.asList("protocol", "port", "domain", "executorName", "redirectPort", "proxyName", "proxyPort", "SSLEnabled", "URIEncoding", "connectionTimeout", "relaxedPathChars", "relaxedQueryChars", "scheme", "allowTrace", "asyncTimeout", "discardFacades", "enableLookups", "encodedSolidusHandling", "parseBodyMethods", "secure", "useBodyEncodingForURI");
                    attributes.forEach(att -> {
                        try {
                            if (mBeanServer.getAttribute(on, (String)att) != null) {
                                attributeMap.put((String)att, mBeanServer.getAttribute(on, (String)att).toString());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    tomcatConnectionInfo.add(new TomcatConnectionInformation(attributeMap));
                }
                tomcatServerInfo = new TomcatServerInformation(shutdown, serverPort, serviceName, tomcatConnectionInfo);
            }
            catch (Exception e) {
                logger.debug("Error reading tomcat server information: ", (Throwable)e);
            }
        }
        return new SystemInformationImpl(plugins, tomcatServerInfo){};
    }

    private String getTomcatDomain(MBeanServer mBeanServer) {
        try {
            mBeanServer.getAttribute(new ObjectName(TOMCAT_EMBED_DOMAIN, "type", "Service"), "connectorNames");
            return TOMCAT_EMBED_DOMAIN;
        }
        catch (Exception e) {
            return TOMCAT_DOMAIN;
        }
    }
}

