/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.systeminformation;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.reconfigure.api.SystemInformationApplication;
import de.resolution.reconfigure.api.SystemInformationApplicationProvider;
import de.resolution.reconfigure.systeminformation.SystemInformationApplicationImpl;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;

@ConfluenceComponent
public class ConfluenceSystemInformationApplicationProvider
implements SystemInformationApplicationProvider {
    private final SystemInformationService systemInformationService;
    private final ClusterManager clusterManager;

    @Inject
    public ConfluenceSystemInformationApplicationProvider(@ComponentImport SystemInformationService systemInformationService, @ComponentImport ClusterManager clusterManager) {
        this.systemInformationService = systemInformationService;
        this.clusterManager = clusterManager;
    }

    @Override
    public SystemInformationApplication getSystemInformationApplication() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("dbName", this.systemInformationService.getDatabaseInfo().getName());
        info.put("dbVersion", this.systemInformationService.getDatabaseInfo().getVersion());
        info.put("appServer", this.systemInformationService.getSystemProperties().getAppServer());
        info.put("jvmInputArguments", this.systemInformationService.getSystemProperties().getJvmInputArguments());
        info.put("dbDriverName", this.systemInformationService.getDatabaseInfo().getDriverName());
        info.put("dbDriverVersion", this.systemInformationService.getDatabaseInfo().getDriverVersion());
        info.put("dbURL", this.systemInformationService.getDatabaseInfo().getUrl());
        info.put("clustering", String.valueOf(this.clusterManager.isClustered()));
        HashSet<String> nodes = new HashSet<String>();
        this.clusterManager.getAllNodesInformation().forEach(node -> nodes.add(this.readNodeName((ClusterNodeInformation)node)));
        return new SystemInformationApplicationImpl(info, nodes);
    }

    private String readNodeName(ClusterNodeInformation node) {
        try {
            return node.humanReadableNodeName().orElse("unknown");
        }
        catch (NoSuchMethodError e) {
            return "API is not available in this Confluence version";
        }
    }
}

