/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.systeminformation;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.reconfigure.api.SystemInformationApplication;
import de.resolution.reconfigure.api.SystemInformationApplicationProvider;
import de.resolution.reconfigure.systeminformation.SystemInformationApplicationImpl;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;

@BitbucketComponent
public class BitbucketSystemInformationApplicationProvider
implements SystemInformationApplicationProvider {
    public final ClusterService clusterService;
    public final ApplicationPropertiesService applicationPropertiesService;

    @Inject
    public BitbucketSystemInformationApplicationProvider(@ComponentImport ClusterService clusterService, @ComponentImport ApplicationPropertiesService applicationPropertiesService) {
        this.clusterService = clusterService;
        this.applicationPropertiesService = applicationPropertiesService;
    }

    @Override
    public SystemInformationApplication getSystemInformationApplication() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("dbDriverName", this.applicationPropertiesService.getJdbcDriver());
        info.put("dbDriverVersion", this.applicationPropertiesService.getJdbcDriverVersion());
        info.put("dbURL", this.applicationPropertiesService.getJdbcUrl());
        info.put("clustering", String.valueOf(this.clusterService.isClustered()));
        HashSet<String> nodes = new HashSet<String>();
        this.clusterService.getInformation().getNodes().forEach(node -> nodes.add(node.getName()));
        return new SystemInformationApplicationImpl(info, nodes);
    }
}

