/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.rest.certificate;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.commons.cert.api.CertUtil;
import de.resolution.commons.cert.api.CertUtilException;
import de.resolution.commons.cert.api.CertificateAndKey;
import de.resolution.commons.cert.api.CertificateCheckResult;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.rest.certificate.CertAndKeyPEM;
import de.resolution.reconfigure.rest.certificate.CertificateCheckResultTransferObject;
import de.resolution.reconfigure.rest.certificate.api.CertUtilProvider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/certificate")
public class CreateCertificateRestResource<C extends Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(CreateCertificateRestResource.class);
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private final CertUtilProvider certUtilProvider;
    private final CertUtil certUtil;

    @Autowired
    public CreateCertificateRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker, CertUtilProvider certUtilProvider) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
        this.certUtilProvider = certUtilProvider;
        this.certUtil = certUtilProvider.getCertUtil();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/createcertandkey/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response createCertAndKey(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws WebSudoRequiredException, InsufficientUserPrivilegeException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        try {
            String cn = "cn=" + this.certUtilProvider.getCommonName();
            CertificateAndKey certAndKey = this.certUtil.createCertificate(cn);
            CertAndKeyPEM certAndKeyPEM = new CertAndKeyPEM(certAndKey);
            logger.info("Created a new certificate {} with key {}", (Object)certAndKeyPEM.cert, (Object)certAndKeyPEM.key);
            return Response.ok((Object)certAndKeyPEM).cacheControl(CC_NO_CACHE).build();
        }
        catch (CertUtilException e) {
            logger.warn("Creating a new certificate failed", (Throwable)e);
            return Response.serverError().cacheControl(CC_NO_CACHE).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/checkcertificate/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response checkCertificate(CertAndKeyPEM certAndKey, @Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        CertificateCheckResult check = this.certUtil.check(certAndKey.cert, certAndKey.key);
        CertificateCheckResultTransferObject to = new CertificateCheckResultTransferObject(check);
        logger.debug("Checking certificate successful");
        return Response.ok((Object)to).cacheControl(CC_NO_CACHE).build();
    }
}

