/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.regex.tester;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.commons.util.boundedregex.RegexAndReplacementResult;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.regex.tester.RegexAndReplacementTestData;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/regexreplacement")
@Component
public class RegexAndReplacementRestResource<C extends Configuration> {
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private static final Logger logger = LoggerFactory.getLogger(RegexAndReplacementRestResource.class);

    @Autowired
    public RegexAndReplacementRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="checkreplacement/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response check(@Nullable String testDataString, @Nullable @Context HttpServletRequest request, @Nullable @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        if (testDataString == null || testDataString.trim().isEmpty()) {
            logger.warn("Test data must not be null or empty");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CC_NO_CACHE).build();
        }
        RegexAndReplacementTestData testData = (RegexAndReplacementTestData)JSONUtil.fromJson((String)testDataString, RegexAndReplacementTestData.class);
        if (request == null) {
            logger.warn("Request must not be null");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CC_NO_CACHE).build();
        }
        ArrayList dataList = new ArrayList();
        testData.regexAndReplacements.forEach(data -> {
            RegexAndReplacement regexAndReplacement = new RegexAndReplacement(data.regex, data.replacement);
            dataList.add(regexAndReplacement);
        });
        try {
            RegexAndReplacementResult result = RegexAndReplacement.apply((String)testData.input, dataList);
            logger.debug("Result for Regex {} : {}", (Object)testData.input, (Object)result.message);
            return Response.ok((Object)result).cacheControl(CC_NO_CACHE).build();
        }
        catch (Exception e) {
            logger.warn("Checking Regex failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

