/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.privilege;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.privilege.ApplicationPermissionChecker;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="privilegeChecker")
@ExportAsService
public class PrivilegeCheckerImpl
implements PrivilegeChecker {
    private static final Logger logger = LoggerFactory.getLogger(PrivilegeCheckerImpl.class);
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;
    private final ApplicationPermissionChecker applicationPermissionChecker;

    @Inject
    public PrivilegeCheckerImpl(@ComponentImport UserManager userManager, @ComponentImport WebSudoManager webSudoManager, ApplicationPermissionChecker applicationPermissionChecker) {
        this.userManager = userManager;
        this.webSudoManager = webSudoManager;
        this.applicationPermissionChecker = applicationPermissionChecker;
    }

    @Override
    public UserProfile checkPrivileges(HttpServletRequest request, Predicate<UserProfile> privilege) throws InsufficientUserPrivilegeException {
        logger.debug("Checking request for privilege {}", privilege);
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null) {
            throw InsufficientUserPrivilegeException.noUserid();
        }
        if (!privilege.test(userProfile)) {
            logger.debug("User {} has insufficient privilege for this request, required privilege is {}", (Object)userProfile.getUsername(), privilege);
            throw InsufficientUserPrivilegeException.insufficientPrivilege(userProfile.getUsername());
        }
        return userProfile;
    }

    @Override
    public void requireWebSudo(boolean webSudoRequired, HttpServletRequest request, HttpServletResponse response) throws WebSudoRequiredException {
        if (!webSudoRequired || this.webSudoManager.canExecuteRequest(request)) {
            if (logger.isDebugEnabled()) {
                if (webSudoRequired) {
                    logger.debug("Websudo required and session is already elevated.");
                } else {
                    logger.debug("Websudo not required for this resource");
                }
            }
            return;
        }
        if (response != null) {
            logger.debug("Websudo required and session was not found. Sending redirect to Websudo permission screen");
            this.webSudoManager.enforceWebSudoProtection(request, response);
        } else {
            logger.debug("Websudo required and session was not found. Sending error as REST response");
        }
        throw new WebSudoRequiredException();
    }

    @Override
    public void checkAdmin(HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.checkPrivileges(request, this.getPrivilegeFactory().isAdmin());
    }

    @Override
    public void checkSysAdmin(HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.checkPrivileges(request, this.getPrivilegeFactory().isSysadmin());
    }

    @Override
    public void checkUser(HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.checkPrivileges(request, this.getPrivilegeFactory().isUser());
    }

    @Override
    public PrivilegeChecker.PrivilegeFactory getPrivilegeFactory() {
        return new PrivilegeFactoryImpl(this.userManager, this.applicationPermissionChecker);
    }

    public static class PrivilegeFactoryImpl
    implements PrivilegeChecker.PrivilegeFactory {
        private final PrivilegeChecker.Privilege isSysadmin;
        private final PrivilegeChecker.Privilege isAdmin;
        private final PrivilegeChecker.Privilege isUser;
        private final PrivilegeChecker.Privilege isAnonymous;
        private final UserManager userManager;
        private final ApplicationPermissionChecker applicationPermissionChecker;

        PrivilegeFactoryImpl(UserManager userManager, ApplicationPermissionChecker applicationPermissionChecker) {
            this.isSysadmin = new PrivilegeImpl(Role.SYSADMIN, userManager, applicationPermissionChecker);
            this.isAdmin = new PrivilegeImpl(Role.ADMIN, userManager, applicationPermissionChecker);
            this.isUser = new PrivilegeImpl(Role.USER, userManager, applicationPermissionChecker);
            this.isAnonymous = new PrivilegeImpl(Role.ANONYMOUS, userManager, applicationPermissionChecker);
            this.userManager = userManager;
            this.applicationPermissionChecker = applicationPermissionChecker;
        }

        @Override
        public PrivilegeChecker.Privilege deny() {
            return userProfile -> false;
        }

        @Override
        public PrivilegeChecker.Privilege isSysadmin() {
            return this.isSysadmin;
        }

        @Override
        public PrivilegeChecker.Privilege isAdmin() {
            return this.isAdmin;
        }

        @Override
        public PrivilegeChecker.Privilege isUser() {
            return this.isUser;
        }

        @Override
        public PrivilegeChecker.Privilege isInGroup(List<String> groups) {
            return new PrivilegeImpl(Role.GROUP_MEMBER, groups, this.userManager, this.applicationPermissionChecker);
        }

        @Override
        public PrivilegeChecker.Privilege hasUserKey(List<String> userKeys) {
            return new PrivilegeImpl(Role.HAS_USER_KEY, userKeys, this.userManager, this.applicationPermissionChecker);
        }

        @Override
        public PrivilegeChecker.Privilege isAnonymous() {
            return this.isAnonymous;
        }
    }

    public static class PrivilegeImpl
    implements PrivilegeChecker.Privilege {
        @Nonnull
        private final Role role;
        @Nullable
        private final List<String> args;
        @Nonnull
        private final UserManager userManager;
        @Nonnull
        private final ApplicationPermissionChecker applicationPermissionChecker;

        PrivilegeImpl(@Nonnull Role role, @Nonnull UserManager userManager, @Nonnull ApplicationPermissionChecker applicationPermissionChecker) {
            this(role, null, userManager, applicationPermissionChecker);
        }

        PrivilegeImpl(@Nonnull Role role, @Nullable List<String> args, @Nonnull UserManager userManager, @Nonnull ApplicationPermissionChecker applicationPermissionChecker) {
            this.role = role;
            this.args = args;
            this.userManager = userManager;
            this.applicationPermissionChecker = applicationPermissionChecker;
        }

        @Override
        public boolean test(@Nullable UserProfile userProfile) {
            if (userProfile == null) {
                return this.role == Role.ANONYMOUS;
            }
            switch (this.role.ordinal()) {
                case 2: 
                case 5: {
                    return this.applicationPermissionChecker.canUseApplication(userProfile);
                }
                case 1: {
                    return this.userManager.isAdmin(userProfile.getUserKey());
                }
                case 0: {
                    return this.userManager.isSystemAdmin(userProfile.getUserKey());
                }
                case 3: {
                    if (this.args == null) {
                        throw new IllegalArgumentException("Args must not be null if GROUP_MEMBER role is being used");
                    }
                    return this.args.stream().anyMatch(groupName -> this.userManager.isUserInGroup(userProfile.getUserKey(), groupName));
                }
                case 4: {
                    if (this.args == null) {
                        throw new IllegalArgumentException("Args must not be null if HAS_USER_KEY role is being used");
                    }
                    return this.args.contains(userProfile.getUserKey().getStringValue());
                }
            }
            throw new IllegalArgumentException("Role was of an unknown value");
        }

        public String toString() {
            return "Privilege{role=" + String.valueOf((Object)this.role) + ", args=" + String.valueOf(this.args) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrivilegeImpl privilege = (PrivilegeImpl)o;
            return this.role == privilege.role && Objects.equals(this.args, privilege.args);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.role, this.args});
        }
    }

    public static enum Role {
        SYSADMIN,
        ADMIN,
        USER,
        GROUP_MEMBER,
        HAS_USER_KEY,
        ANONYMOUS;

    }
}

