/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.privilege;

import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlascompat.factory.util.Version;
import de.resolution.reconfigure.privilege.ApplicationPermissionChecker;
import jakarta.inject.Inject;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ConfluencePermissionCheckerImpl
implements ApplicationPermissionChecker {
    private static final Logger logger = LoggerFactory.getLogger(ConfluencePermissionCheckerImpl.class);
    private final UserAccessor userAccessor;
    private final ConfluenceAccessManager confluenceUserManager;
    private final AtlasCompatApiFactory atlasCompatApiFactory;

    @Inject
    public ConfluencePermissionCheckerImpl(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport ConfluenceAccessManager confluenceUserManager, AtlasCompatApiFactory atlasCompatApiFactory) {
        this.userAccessor = userAccessor;
        this.confluenceUserManager = confluenceUserManager;
        this.atlasCompatApiFactory = atlasCompatApiFactory;
    }

    @Override
    public boolean canUseApplication(@Nullable UserProfile userProfile) {
        if (userProfile == null) {
            return false;
        }
        try {
            if (Version.of((String)this.atlasCompatApiFactory.getPlatformApplicationVersion()).isGreaterThanOrEqual("8.8.0")) {
                ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(userProfile.getUserKey());
                return this.confluenceUserManager.getUserAccessStatus(confluenceUser).hasLicensedAccess();
            }
            ConfluenceUser user = this.userAccessor.getUserByKey(userProfile.getUserKey());
            return this.confluenceUserManager.getUserAccessStatus((User)user).hasLicensedAccess();
        }
        catch (NoSuchMethodError e) {
            logger.error("Unable to detect if user is allowed to use the application", (Throwable)e);
            return false;
        }
    }
}

