/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest.fromscheduler.cron;

import de.resolution.reconfigure.cronexpressionrest.fromscheduler.Util;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.cron.ErrorCode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class CronSyntaxException
extends Exception {
    private static final long serialVersionUID = 5594187147397941674L;
    private final ErrorCode errorCode;
    private final String cronExpression;
    private final String value;
    private final int errorOffset;

    CronSyntaxException(Builder builder) {
        super(builder.toMessage());
        this.errorCode = Util.firstNonNull(builder.errorCode, ErrorCode.INTERNAL_PARSER_FAILURE);
        this.cronExpression = Util.firstNonNull(builder.cronExpression, "");
        this.value = builder.value;
        this.errorOffset = builder.errorOffset;
        if (builder.cause != null) {
            this.initCause(builder.cause);
        }
    }

    @Nonnull
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nonnull
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public int getErrorOffset() {
        return this.errorOffset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String cronExpression;
        String value;
        ErrorCode errorCode;
        int errorOffset = -1;
        Throwable cause;

        Builder() {
        }

        public Builder cronExpression(@Nullable String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public Builder value(char value) {
            this.value = String.valueOf(value);
            return this;
        }

        public Builder errorCode(@Nullable ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder errorOffset(int errorOffset) {
            this.errorOffset = errorOffset >= 0 ? errorOffset : -1;
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public CronSyntaxException build() {
            return new CronSyntaxException(this);
        }

        @Nonnull
        String toMessage() {
            return this.errorCode.toMessage(this.value);
        }
    }
}

